/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.utils;

import cn.unitid.cip.sdk.dto.cert.PersonalSeniorCertificate;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.ApiUtils;
import cn.unitid.cip.sdk.internal.util.RandomStringUtils;
import cn.unitid.cip.sdk.internal.util.RequestParametersHolder;
import cn.unitid.cip.sdk.internal.util.WebUtils;
import cn.unitid.cip.sdk.request.sop.personal.PersonalIssueRequest;
import java.io.IOException;
import java.util.Map;

public class CertGenHelper {
    public static String issueHttpParam(String url, String account, String p10, String appKey, String appSecret) throws IOException {
        PersonalIssueRequest request = new PersonalIssueRequest();
        PersonalSeniorCertificate personalSeniorCertificate = new PersonalSeniorCertificate();
        personalSeniorCertificate.setCommonName(account);
        personalSeniorCertificate.setAccountId(account);
        request.setPersonalSeniorCertificate(personalSeniorCertificate);
        request.setPkCS10(p10);
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        ApiHashMap appParams = new ApiHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        ApiHashMap protocalMustParams = new ApiHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", "1");
        protocalMustParams.put("appKey", appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)timestamp);
        protocalMustParams.put("nonce", RandomStringUtils.randomAlphanumeric(10));
        request.getHeaderMap().put("x-request-id", RandomStringUtils.randomAlphanumeric(10));
        requestHolder.setProtocalMustParams(protocalMustParams);
        ApiHashMap protocalOptParams = new ApiHashMap();
        protocalOptParams.put("format", "json");
        protocalOptParams.put("signMethod", "HMAC-SHA256");
        protocalOptParams.put("signVersion", "1.0");
        protocalOptParams.put("simplify", Boolean.TRUE.toString());
        requestHolder.setProtocalOptParams(protocalOptParams);
        protocalMustParams.put("sign", ApiUtils.signTopRequest(requestHolder, appSecret, "HMAC-SHA256"));
        String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
        String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
        String appQuery = WebUtils.buildQuery(requestHolder.getApplicationParams(), "UTF-8");
        String fullUrl = WebUtils.buildRequestUrl(url + "/rest/cip/kitty/cert/sop/issue", sysMustQuery, sysOptQuery, appQuery);
        return fullUrl;
    }
}

