/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.test;

import cn.unitid.cip.sdk.ApiClient;
import cn.unitid.cip.sdk.DefaultApiClient;
import cn.unitid.cip.sdk.dto.cert.PersonalSeniorCertificate;
import cn.unitid.cip.sdk.request.sop.CertQueryBySerialRequest;
import cn.unitid.cip.sdk.request.sop.PostponeRequest;
import cn.unitid.cip.sdk.request.sop.RevokeRequest;
import cn.unitid.cip.sdk.request.sop.personal.PersonalIssueRequest;
import cn.unitid.cip.sdk.response.sop.CertQueryBySerialResponse;
import cn.unitid.cip.sdk.response.sop.PostponeResponse;
import cn.unitid.cip.sdk.response.sop.RevokeResponse;
import cn.unitid.cip.sdk.response.sop.personal.PersonalIssueResponse;
import cn.unitid.cip.sdk.service.CertSopApi;
import cn.unitid.cip.sdk.service.PersonalCertSopApi;
import cn.unitid.cip.sdk.service.impl.CertSopApiImpl;
import cn.unitid.cip.sdk.service.impl.PersonalCertSopApiImpl;
import cn.unitid.cip.sdk.test.P10Util;
import org.junit.Assert;

public class PersonalCertSopApiTest {
    static final String appKey = "w8MuGC9C";
    static final String secretKey = "4wVznIMB";
    protected static final String CIP_SDK_URL_SSL = "https://172.16.3.161:50050/rest";
    static ApiClient apiClient = PersonalCertSopApiTest.getDevClient();
    static CertSopApi certSopApi = new CertSopApiImpl(apiClient);
    static PersonalCertSopApi personalCertSopApi = new PersonalCertSopApiImpl(apiClient);

    private static ApiClient getDevClient() {
        DefaultApiClient apiClient = new DefaultApiClient(CIP_SDK_URL_SSL, appKey, secretKey);
        return apiClient;
    }

    public static void main(String[] args) throws Exception {
        PersonalCertSopApiTest.testCert();
    }

    private static void testCert() throws Exception {
        String serial = PersonalCertSopApiTest.testIssue();
        String serialPostpone = PersonalCertSopApiTest.testPostpone(serial);
        Assert.assertTrue((!serialPostpone.equals(serial) ? 1 : 0) != 0);
        String serialGet = PersonalCertSopApiTest.getBySerial(serialPostpone);
        Assert.assertTrue((boolean)serialGet.equals(serialPostpone));
        boolean result = PersonalCertSopApiTest.testRevoke(serialGet);
        Assert.assertTrue((boolean)result);
    }

    public static String testIssue() throws Exception {
        PersonalIssueRequest request = new PersonalIssueRequest();
        PersonalSeniorCertificate personalSeniorCertificate = PersonalCertSopApiTest.getPersonalSeniorCertificate();
        request.setPersonalSeniorCertificate(personalSeniorCertificate);
        try {
            request.setPkCS10(P10Util.p10Structure("CN=\u5434\u4f1f\u4f1fww,OU=\u58f9\u8bc1\u901a,O=SmartCA,L=\u5357\u4eac\u5e02,ST=\u6c5f\u82cf\u7701,C=CN").getP10());
        }
        catch (Exception e) {
            request.setPkCS10("");
        }
        PersonalIssueResponse personalIssueResponse = null;
        personalIssueResponse = personalCertSopApi.issue(request);
        System.out.println("================================");
        Assert.assertTrue((boolean)personalIssueResponse.isSuccess());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,\u54cd\u5e94\u5185\u5bb9:" + personalIssueResponse);
        System.out.println("================================");
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,SDK\u8bf7\u6c42ID:" + personalIssueResponse.getRequestId());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,SDK\u54cd\u5e94\u6d88\u606f:" + personalIssueResponse.getMsg());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,SDK\u54cd\u5e94\u7801:" + personalIssueResponse.getErrorCode());
        System.out.println("================================");
        Assert.assertTrue((personalIssueResponse.isSuccess() && null != personalIssueResponse.getData() ? 1 : 0) != 0);
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u8bc1\u4e66ID:" + personalIssueResponse.getData().getSerial());
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u52a0\u5bc6\u8bc1\u4e66:" + personalIssueResponse.getData().getEncryptionCert());
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u52a0\u5bc6\u8bc1\u4e66\u79c1\u94a5:" + personalIssueResponse.getData().getEncryptionPrivateKey());
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u7b7e\u540d\u8bc1\u4e66:" + personalIssueResponse.getData().getSignatureCert());
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u7801:" + personalIssueResponse.getData().getIncorrect());
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u6d88\u606f:" + personalIssueResponse.getData().getMessage());
        System.out.println("\u7b7e\u53d1\u6210\u529f\uff0c\u4ecb\u8d28\u4fe1\u606f:" + personalIssueResponse.getData().getMedium());
        return personalIssueResponse.getData().getSerial();
    }

    private static PersonalSeniorCertificate getPersonalSeniorCertificate() {
        PersonalSeniorCertificate personalSeniorCertificate = new PersonalSeniorCertificate();
        personalSeniorCertificate.setAccountId("021100000169");
        return personalSeniorCertificate;
    }

    public static String getBySerial(String serial) throws Exception {
        CertQueryBySerialRequest request = new CertQueryBySerialRequest();
        request.setSerial(serial);
        CertQueryBySerialResponse certQueryBySerialResponse = certSopApi.queryBySerial(request);
        System.out.println("================================");
        Assert.assertTrue((boolean)certQueryBySerialResponse.isSuccess());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,\u54cd\u5e94\u5185\u5bb9:" + certQueryBySerialResponse);
        System.out.println("================================");
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,SDK\u8bf7\u6c42ID:" + certQueryBySerialResponse.getRequestId());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,SDK\u54cd\u5e94\u6d88\u606f:" + certQueryBySerialResponse.getMsg());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f,SDK\u54cd\u5e94\u7801:" + certQueryBySerialResponse.getErrorCode());
        System.out.println("================================");
        Assert.assertTrue((certQueryBySerialResponse.isSuccess() && null != certQueryBySerialResponse.getData() ? 1 : 0) != 0);
        System.out.println("\u67e5\u8be2\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u7801:" + certQueryBySerialResponse.getData().getIncorrect());
        System.out.println("\u67e5\u8be2\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u6d88\u606f:" + certQueryBySerialResponse.getData().getMessage());
        System.out.println("\u67e5\u8be2\u6210\u529f\uff0c\u8bc1\u4e66:" + certQueryBySerialResponse.getData().getCertificate());
        return certQueryBySerialResponse.getData().getCertificate().getCertSerial();
    }

    public static String testPostpone(String serial) throws Exception {
        PostponeRequest request = new PostponeRequest();
        request.setSerial(serial);
        PostponeResponse postponeResponse = certSopApi.postpone(request);
        System.out.println("================================");
        Assert.assertTrue((boolean)postponeResponse.isSuccess());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u54cd\u5e94\u5185\u5bb9:" + postponeResponse);
        System.out.println("================================");
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0cSDK\u8bf7\u6c42ID:" + postponeResponse.getRequestId());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0cSDK\u54cd\u5e94\u6d88\u606f:" + postponeResponse.getMsg());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0cSDK\u54cd\u5e94\u7801:" + postponeResponse.getErrorCode());
        System.out.println("================================");
        Assert.assertTrue((postponeResponse.isSuccess() && null != postponeResponse.getData() ? 1 : 0) != 0);
        System.out.println("\u5ef6\u671f\u6210\u529f\uff0c\u8bc1\u4e66\u5e8f\u5217\u53f7:" + postponeResponse.getData().getSerial());
        System.out.println("\u5ef6\u671f\u6210\u529f\uff0c\u52a0\u5bc6\u8bc1\u4e66:" + postponeResponse.getData().getEncryptionCert());
        System.out.println("\u5ef6\u671f\u6210\u529f\uff0c\u52a0\u5bc6\u8bc1\u4e66\u79c1\u94a5:" + postponeResponse.getData().getEncryptionPrivateKey());
        System.out.println("\u5ef6\u671f\u6210\u529f\uff0c\u7b7e\u540d\u8bc1\u4e66:" + postponeResponse.getData().getSignatureCert());
        System.out.println("\u5ef6\u671f\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u7801:" + postponeResponse.getData().getIncorrect());
        System.out.println("\u5ef6\u671f\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u6d88\u606f:" + postponeResponse.getData().getMessage());
        return postponeResponse.getData().getSerial();
    }

    public static boolean testRevoke(String serial) throws Exception {
        RevokeRequest request = new RevokeRequest();
        request.setSerial(serial);
        RevokeResponse revokeResponse = certSopApi.revoke(request);
        Assert.assertTrue((boolean)revokeResponse.isSuccess());
        System.out.println("================================");
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0cSDK\u8bf7\u6c42ID:" + revokeResponse.getRequestId());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0cSDK\u54cd\u5e94\u6d88\u606f:" + revokeResponse.getMsg());
        System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0cSDK\u54cd\u5e94\u7801:" + revokeResponse.getErrorCode());
        System.out.println("================================");
        Assert.assertTrue((revokeResponse.isSuccess() && null != revokeResponse.getData() ? 1 : 0) != 0);
        System.out.println("\u6ce8\u9500\u6210\u529f\uff0c\u6ce8\u9500\u7ed3\u679c:" + revokeResponse.getData().getResult());
        System.out.println("\u6ce8\u9500\u6210\u529f\uff0c\u8bc1\u4e66\u5e8f\u5217\u53f7:" + revokeResponse.getData().getSerial());
        System.out.println("\u6ce8\u9500\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u7801:" + revokeResponse.getData().getIncorrect());
        System.out.println("\u6ce8\u9500\u6210\u529f\uff0c\u4e1a\u52a1\u54cd\u5e94\u6d88\u606f:" + revokeResponse.getData().getMessage());
        return revokeResponse.getData().getResult();
    }
}

