/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.test;

import cn.unitid.cip.sdk.dto.cert.BaseCertificate;
import cn.unitid.easypki.pkcs10.PKCS10CertificateRequestBuilder;
import cn.unitid.easypki.security.SM2BCKeyPair;
import cn.unitid.easypki.security.SM2BCKeyPairGenerator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class P10Util {
    private P10Info p10Info;

    public static P10Info p10Structure(String subject) throws Exception {
        SM2BCKeyPair kp = SM2BCKeyPairGenerator.generateKeyPair();
        BCECPublicKey sm2PublicKey = kp.getBCECPublicKey();
        BCECPrivateKey sm2PrivateKey = kp.getBCECPrivateKey();
        X500Name subjectX500Name = new X500Name(subject);
        PKCS10CertificationRequest p10 = PKCS10CertificateRequestBuilder.buildPKCS10CertificationRequest((X500Name)subjectX500Name, (BCECPublicKey)sm2PublicKey, (ECPrivateKey)sm2PrivateKey);
        return new P10Info(new String(Base64.encodeBase64((byte[])p10.getEncoded())), p10, sm2PublicKey, sm2PrivateKey);
    }

    public static P10Info p10Structure(BaseCertificate certificate) throws Exception {
        String subject = P10Util.genDn(certificate);
        return P10Util.p10Structure(subject);
    }

    private static String genDn(BaseCertificate certificate) {
        String cn = certificate.getCommonName();
        String organization = certificate.getOrganization();
        String organizationUnit = certificate.getOrganizationUnit();
        String province = certificate.getProvince();
        String city = certificate.getCity();
        String country = certificate.getCountry();
        String givenName = certificate.getGivenName();
        assert (!(StringUtils.isEmpty((CharSequence)cn) || StringUtils.isEmpty((CharSequence)organization) || StringUtils.isEmpty((CharSequence)organizationUnit) || StringUtils.isEmpty((CharSequence)province) || StringUtils.isEmpty((CharSequence)city) || StringUtils.isEmpty((CharSequence)country)));
        StringBuilder subjectNew = new StringBuilder();
        subjectNew.append("CN=");
        subjectNew.append(cn);
        subjectNew.append(",");
        subjectNew.append("OU=");
        subjectNew.append(organizationUnit);
        subjectNew.append(",");
        subjectNew.append("O=");
        subjectNew.append(organization);
        subjectNew.append(",");
        subjectNew.append("ST=");
        subjectNew.append(province);
        subjectNew.append(",");
        subjectNew.append("L=");
        subjectNew.append(city);
        subjectNew.append(",");
        subjectNew.append("C=");
        subjectNew.append(country);
        subjectNew.append(",");
        subjectNew.append("GIVENNAME=");
        subjectNew.append(givenName);
        return subjectNew.toString();
    }

    public static BaseCertificate getBaseCertificateFromP10(String p10) throws Exception {
        PKCS10CertificationRequest pkcs10 = new PKCS10CertificationRequest(Base64.decodeBase64((String)p10));
        X500Name x500Subject = pkcs10.getSubject();
        String subject = x500Subject.toString();
        String[] kvs = subject.split(",");
        BaseCertificate baseCertificate = new BaseCertificate();
        int size = kvs.length;
        if (size <= 1) {
            return baseCertificate;
        }
        for (int i = 0; i < size; ++i) {
            String name = kvs[i].split("=")[0].trim();
            if ("CN".equals(name)) {
                baseCertificate.setCommonName(kvs[i].split("=")[1].trim());
                continue;
            }
            if ("C".equals(name)) {
                baseCertificate.setCountry(kvs[i].split("=")[1].trim());
                continue;
            }
            if ("OU".equals(name)) {
                baseCertificate.setOrganizationUnit(kvs[i].split("=")[1].trim());
                continue;
            }
            if ("ST".equals(name)) {
                baseCertificate.setProvince(kvs[i].split("=")[1].trim());
                continue;
            }
            if ("L".equals(name)) {
                baseCertificate.setCity(kvs[i].split("=")[1].trim());
                continue;
            }
            if (!"O".equals(name)) continue;
            baseCertificate.setOrganization(kvs[i].split("=")[1].trim());
        }
        AlgorithmIdentifier algorithm = pkcs10.getSignatureAlgorithm();
        if ("1.2.156.10197.1.501".equals(algorithm.getAlgorithm().getId())) {
            baseCertificate.setAlgo("SM2");
            baseCertificate.setLength("256");
        } else {
            baseCertificate.setAlgo("RSA");
            baseCertificate.setLength("1024");
        }
        return baseCertificate;
    }

    public static class P10Info {
        String p10;
        PKCS10CertificationRequest pkCs10;
        BCECPublicKey sm2PublicKey;
        BCECPrivateKey sm2PrivateKey;

        public String getP10() {
            return this.p10;
        }

        public PKCS10CertificationRequest getPkCs10() {
            return this.pkCs10;
        }

        public BCECPublicKey getSm2PublicKey() {
            return this.sm2PublicKey;
        }

        public BCECPrivateKey getSm2PrivateKey() {
            return this.sm2PrivateKey;
        }

        public P10Info(String p10, PKCS10CertificationRequest pkCs10, BCECPublicKey sm2PublicKey, BCECPrivateKey sm2PrivateKey) {
            this.p10 = p10;
            this.pkCs10 = pkCs10;
            this.sm2PublicKey = sm2PublicKey;
            this.sm2PrivateKey = sm2PrivateKey;
        }

        public String toString() {
            return "P10Info{p10='" + this.p10 + '\'' + ", pkCs10=" + this.pkCs10 + ", sm2PublicKey=" + this.sm2PublicKey + ", sm2PrivateKey=" + this.sm2PrivateKey + '}';
        }
    }
}

