/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.cip;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.request.sop.cip.KeyUsageType;
import cn.unitid.cip.sdk.response.sop.cip.ApiByteCipEncryptSm2Response;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class ApiByteCipEncryptSm2Request
extends BaseApiRequest<ApiByteCipEncryptSm2Response> {
    private Integer cipIndex;
    private byte[] encryptData;
    private KeyUsageType keyUsageType;

    @Override
    public String getApiMethodName() {
        return "encrypt.sm2";
    }

    @Override
    public String getApiModel() {
        return "cip";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("cipIndex", (Object)this.cipIndex);
        txtParams.put("encryptData", Hex.encodeHexString((byte[])this.encryptData));
        txtParams.put("keyUsageType", (Object)this.keyUsageType);
        return txtParams;
    }

    @Override
    public Class<ApiByteCipEncryptSm2Response> getResponseClass() {
        return ApiByteCipEncryptSm2Response.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.cipIndex, "cipIndex");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString((byte[])this.encryptData), "encryptData");
        int length = this.encryptData.length;
        if (length > 136) {
            throw new ApiRuleException(10006, "client-error:'encryptData' length must be less than or equal to 136");
        }
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public Integer getCipIndex() {
        return this.cipIndex;
    }

    public void setCipIndex(Integer cipIndex) {
        this.cipIndex = cipIndex;
    }

    public byte[] getEncryptData() {
        return this.encryptData;
    }

    public void setEncryptData(byte[] encryptData) {
        this.encryptData = encryptData;
    }

    public KeyUsageType getKeyUsageType() {
        return this.keyUsageType;
    }

    public void setKeyUsageType(KeyUsageType keyUsageType) {
        this.keyUsageType = keyUsageType;
    }
}

