/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.internal.util;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.FileItem;
import cn.unitid.cip.sdk.dto.cert.BaseCertificate;
import cn.unitid.cip.sdk.dto.cert.EnterpriseSeniorCertificate;
import cn.unitid.cip.sdk.dto.cert.PersonalSeniorCertificate;
import cn.unitid.cip.sdk.internal.util.json.JSONReader;
import cn.unitid.cip.sdk.internal.util.json.JSONValidatingReader;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestCheckUtils {
    public static final int ERROR_CODE_ARGUMENTS_MISSING = 10005;
    public static final String REGEX_MOBILE = "^1[0-9]{10}$";
    public static final String REGEX_PHONE = "\\d{3}-\\d{8}|\\d{4}-\\d{7}|^0[0-9]{10}$";
    public static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String REGEX_ID_CARD = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)";

    public static void checkNotEmpty(Object value, String fieldName) throws ApiRuleException {
        if (value == null) {
            throw new ApiRuleException(10005, "client-error:Missing required arguments:" + fieldName + "");
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            throw new ApiRuleException(10005, "client-error:Missing required arguments:" + fieldName + "");
        }
        if (value instanceof List && ((List)value).size() == 0) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the list of" + fieldName + "can not be empty .");
        }
    }

    public static void checkNotCertType(BaseCertificate baseCertificate) throws ApiRuleException {
        if (baseCertificate == null) {
            throw new ApiRuleException(10005, "client-error:Missing required arguments:EnterpriseSeniorCertificate or PersonalSeniorCertificate");
        }
        if (!(baseCertificate instanceof EnterpriseSeniorCertificate) && !(baseCertificate instanceof PersonalSeniorCertificate)) {
            throw new ApiRuleException(10005, "client-error:Missing required arguments:EnterpriseSeniorCertificate or PersonalSeniorCertificate");
        }
    }

    public static void checkMaxLength(String value, int maxLength, String fieldName) throws ApiRuleException {
        if (value != null && value.length() > maxLength) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the string length of " + fieldName + " can not be larger than " + maxLength + ".");
        }
    }

    public static void checkMaxLength(FileItem fileItem, int maxLength, String fieldName) throws ApiRuleException {
        if (fileItem != null && fileItem.getFileLength() > (long)maxLength) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the file size of " + fieldName + " can not be larger than " + maxLength + ".");
        }
    }

    public static void checkMaxListSize(String value, int maxSize, String fieldName) throws ApiRuleException {
        String[] list;
        if (value != null && (list = value.split(",")) != null && list.length > maxSize) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the array size of " + fieldName + " must be less than " + maxSize + ".");
        }
    }

    public static void checkObjectMaxListSize(String value, int maxSize, String fieldName) throws ApiRuleException {
        JSONValidatingReader reader;
        Object obj;
        if (value != null && (obj = ((JSONReader)(reader = new JSONValidatingReader())).read(value)) instanceof List && ((List)obj).size() > maxSize) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the array size of " + fieldName + " must be less than " + maxSize + ".");
        }
    }

    public static void checkMaxValue(Long value, long maxValue, String fieldName) throws ApiRuleException {
        if (value != null && value > maxValue) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName + " can not be larger than " + maxValue + ".");
        }
    }

    public static void checkMinValue(Long value, long minValue, String fieldName) throws ApiRuleException {
        if (value != null && value < minValue) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName + " can not be less than " + minValue + ".");
        }
    }

    public static void checkEmail(String value, String fieldName) throws ApiRuleException {
        Pattern regex;
        Matcher m;
        boolean result;
        if (value.trim().length() != 0 && !(result = (m = (regex = Pattern.compile(REGEX_EMAIL)).matcher(value)).matches())) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName);
        }
    }

    public static void checkIdNumber(String value, String fieldName) throws ApiRuleException {
        Pattern regex;
        Matcher m;
        boolean result;
        if (value.trim().length() != 0 && !(result = (m = (regex = Pattern.compile(REGEX_ID_CARD)).matcher(value)).matches())) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName);
        }
    }

    public static void checkPhone(String value, String fieldName) throws ApiRuleException {
        if (value.trim().length() != 0) {
            boolean result;
            Pattern regex = Pattern.compile(REGEX_MOBILE);
            Pattern regexPhone = Pattern.compile(REGEX_PHONE);
            Matcher m = regex.matcher(value);
            Matcher m2 = regexPhone.matcher(value);
            boolean bl = result = m.matches() || m2.matches();
            if (!result) {
                throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName);
            }
        }
    }

    public static void checkTime(Date date, String fieldName) throws ApiRuleException {
        if (date != null && date.before(RequestCheckUtils.initDateByDay())) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of  " + fieldName + "  should not earlier than  " + RequestCheckUtils.initDateByDay());
        }
    }

    public static void checkOid(String oid, String fieldName) throws ApiRuleException {
        if (oid == null || !RequestCheckUtils.isValidIdentifier(oid)) {
            throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName);
        }
    }

    public static void checkTime(Date start, Date end, String fieldName, String fildNameTwo) throws ApiRuleException {
        if (start != null && end != null) {
            if (end.before(start)) {
                throw new ApiRuleException(10005, "client-error:Invalid arguments:the value of " + fieldName + " should  earlier than  " + fildNameTwo);
            }
            int days = (int)((end.getTime() - start.getTime()) / 86400000L);
            if (days > 1825) {
                throw new ApiRuleException(10005, "client-error:Invalid arguments:the days between  " + fieldName + "  and   " + fildNameTwo + " should not bigger than 1825");
            }
        }
    }

    private static Date initDateByDay() {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        return new Date(zero);
    }

    private static boolean isValidBranchID(String var0, int var1) {
        boolean var2 = false;
        int var3 = var0.length();
        while (--var3 >= var1) {
            char var4 = var0.charAt(var3);
            if ('0' <= var4 && var4 <= '9') {
                var2 = true;
                continue;
            }
            if (var4 != '.') {
                return false;
            }
            if (!var2) {
                return false;
            }
            var2 = false;
        }
        return var2;
    }

    private static boolean isValidIdentifier(String var0) {
        if (var0.length() >= 3 && var0.charAt(1) == '.') {
            char var1 = var0.charAt(0);
            return var1 >= '0' && var1 <= '2' ? RequestCheckUtils.isValidBranchID(var0, 2) : false;
        }
        return false;
    }
}

