/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.dto.cert;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.dto.Dto;
import cn.unitid.cip.sdk.dto.cert.Extension;
import cn.unitid.cip.sdk.internal.util.ApiUUID;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.internal.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseCertificate
implements Dto {
    private static final long serialVersionUID = -7927320290086365842L;
    private String id;
    private String certId;
    private String certSerial;
    private String commonName;
    private String organization;
    private String organizationUnit;
    private String country = "CN";
    private String province;
    private String city;
    private String districtCounty;
    private String givenName;
    private Date notBefore;
    private Date notAfter;
    private String email;
    private String algo;
    private String length;
    private String certificateType;
    private String status;
    private String encCertificate;
    private String encryptionPrivateKey;
    private String sigCertificate;
    private String subject;
    private String skfEnvelopedKeyBlob;
    private String extend;
    private String fingerprint;
    private String medium;
    private String accountId;
    private List<Extension> extraExtension;

    public void setId(String id) {
        this.id = id;
    }

    public String getCertId() {
        if (StringUtils.isEmpty(this.certId)) {
            this.certId = !StringUtils.isEmpty(this.id) ? this.id : ApiUUID.uuid();
        }
        return this.certId;
    }

    @Deprecated
    public void setCertId(String certId) {
        this.certId = certId;
    }

    public String getCertSerial() {
        return this.certSerial;
    }

    public void setCertSerial(String certSerial) {
        this.certSerial = certSerial;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrictCounty() {
        return this.districtCounty;
    }

    public void setDistrictCounty(String districtCounty) {
        this.districtCounty = districtCounty;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEncCertificate() {
        return this.encCertificate;
    }

    public void setEncCertificate(String encCertificate) {
        this.encCertificate = encCertificate;
    }

    public String getEncryptionPrivateKey() {
        return this.encryptionPrivateKey;
    }

    public void setEncryptionPrivateKey(String encryptionPrivateKey) {
        this.encryptionPrivateKey = encryptionPrivateKey;
    }

    public String getSigCertificate() {
        return this.sigCertificate;
    }

    public void setSigCertificate(String sigCertificate) {
        this.sigCertificate = sigCertificate;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    @Override
    public Map<String, String> getMapParam(String param) {
        HashMap<String, String> mapParam = new HashMap<String, String>(10);
        if (!StringUtils.isEmpty(this.getCertId())) {
            mapParam.put(param + "certId", this.getCertId());
        }
        if (!StringUtils.isEmpty(this.getCertId())) {
            mapParam.put(param + "id", this.getCertId());
        }
        if (!StringUtils.isEmpty(this.getCommonName())) {
            mapParam.put(param + "commonName", this.getCommonName());
        }
        if (!StringUtils.isEmpty(this.getOrganization())) {
            mapParam.put(param + "organization", this.getOrganization());
        }
        if (!StringUtils.isEmpty(this.getOrganizationUnit())) {
            mapParam.put(param + "organizationUnit", this.getOrganizationUnit());
        }
        if (!StringUtils.isEmpty(this.getCountry())) {
            mapParam.put(param + "country", this.getCountry());
        }
        if (!StringUtils.isEmpty(this.getProvince())) {
            mapParam.put(param + "province", this.getProvince());
        }
        if (!StringUtils.isEmpty(this.getCity())) {
            mapParam.put(param + "city", this.getCity());
        }
        if (!StringUtils.isEmpty(this.getDistrictCounty())) {
            mapParam.put(param + "districtCounty", this.getDistrictCounty());
        }
        if (null != this.notBefore) {
            mapParam.put(param + "notBefore", StringUtils.formatDateTime(this.getNotBefore()));
        }
        if (null != this.notAfter) {
            mapParam.put(param + "notAfter", StringUtils.formatDateTime(this.getNotAfter()));
        }
        if (!StringUtils.isEmpty(this.getEmail())) {
            mapParam.put(param + "email", this.getEmail());
        }
        if (!StringUtils.isEmpty(this.getMedium())) {
            mapParam.put(param + "medium", this.getMedium());
        }
        if (!StringUtils.isEmpty(this.getAccountId())) {
            mapParam.put(param + "accountId", this.getAccountId());
        }
        if (!StringUtils.isEmpty(this.getAlgo())) {
            mapParam.put(param + "algo", this.getAlgo());
            mapParam.put(param + "keyAlgorithm", this.getAlgo());
        }
        if (!StringUtils.isEmpty(this.getAlgo())) {
            mapParam.put(param + "length", this.getLength());
            mapParam.put(param + "keyLength", this.getLength());
        }
        if (null != this.extraExtension && this.extraExtension.size() > 0) {
            for (int i = 0; i < this.extraExtension.size(); ++i) {
                mapParam.put(param + "extraExtension[" + i + "].oid", this.extraExtension.get(i).getOid());
                mapParam.put(param + "extraExtension[" + i + "].value", this.extraExtension.get(i).getValue());
                if (null == this.extraExtension.get(i).getName() || this.extraExtension.get(i).getName().length() <= 0) continue;
                mapParam.put(param + "certExtension[" + i + "].name", this.extraExtension.get(i).getName());
            }
        }
        return mapParam;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.accountId, "accountId");
    }

    public String getAlgo() {
        return this.algo;
    }

    public void setAlgo(String algo) {
        this.algo = algo;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getSkfEnvelopedKeyBlob() {
        return this.skfEnvelopedKeyBlob;
    }

    public void setSkfEnvelopedKeyBlob(String skfEnvelopedKeyBlob) {
        this.skfEnvelopedKeyBlob = skfEnvelopedKeyBlob;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public List<Extension> getExtraExtension() {
        return this.extraExtension;
    }

    public void setExtraExtension(List<Extension> extraExtension) {
        this.extraExtension = extraExtension;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }
}

