/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.asn1.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.Attributes;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable attrs) {
        this.attributes = this.copyTable(attrs);
    }

    public AttributeTable(ASN1EncodableVector v) {
        for (int i = 0; i != v.size(); ++i) {
            Attribute a = Attribute.getInstance(v.get(i));
            this.addAttribute(a.getAttrType(), a);
        }
    }

    public AttributeTable(ASN1Set s) {
        for (int i = 0; i != s.size(); ++i) {
            Attribute a = Attribute.getInstance(s.getObjectAt(i));
            this.addAttribute(a.getAttrType(), a);
        }
    }

    public AttributeTable(Attribute attr) {
        this.addAttribute(attr.getAttrType(), attr);
    }

    public AttributeTable(Attributes attrs) {
        this(ASN1Set.getInstance(attrs.toASN1Primitive()));
    }

    private void addAttribute(ASN1ObjectIdentifier oid, Attribute a) {
        Object value = this.attributes.get(oid);
        if (value == null) {
            this.attributes.put(oid, a);
        } else {
            Vector<Object> v;
            if (value instanceof Attribute) {
                v = new Vector<Object>();
                v.addElement(value);
                v.addElement(a);
            } else {
                v = (Vector<Object>)value;
                v.addElement(a);
            }
            this.attributes.put(oid, v);
        }
    }

    public Attribute get(ASN1ObjectIdentifier oid) {
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            return (Attribute)((Vector)value).elementAt(0);
        }
        return (Attribute)value;
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier oid) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            Enumeration e = ((Vector)value).elements();
            while (e.hasMoreElements()) {
                v.add((Attribute)e.nextElement());
            }
        } else if (value != null) {
            v.add((Attribute)value);
        }
        return v;
    }

    public int size() {
        int size = 0;
        Enumeration en = this.attributes.elements();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o instanceof Vector) {
                size += ((Vector)o).size();
                continue;
            }
            ++size;
        }
        return size;
    }

    public Hashtable toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            if (value instanceof Vector) {
                Enumeration en = ((Vector)value).elements();
                while (en.hasMoreElements()) {
                    v.add(Attribute.getInstance(en.nextElement()));
                }
                continue;
            }
            v.add(Attribute.getInstance(value));
        }
        return v;
    }

    public Attributes toASN1Structure() {
        return new Attributes(this.toASN1EncodableVector());
    }

    private Hashtable copyTable(Hashtable in) {
        Hashtable out = new Hashtable();
        Enumeration e = in.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            out.put(key, in.get(key));
        }
        return out;
    }

    public AttributeTable add(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        AttributeTable newTable = new AttributeTable(this.attributes);
        newTable.addAttribute(attrType, new Attribute(attrType, new DERSet(attrValue)));
        return newTable;
    }

    public AttributeTable remove(ASN1ObjectIdentifier attrType) {
        AttributeTable newTable = new AttributeTable(this.attributes);
        newTable.attributes.remove(attrType);
        return newTable;
    }
}

