/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.util;

import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.provider.identifier.EPAlgorithmIdentifier;
import cn.unitid.easypki.security.EPMessageDigest;
import cn.unitid.easypki.security.RSASignature;
import cn.unitid.easypki.security.SM2Signature;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import cn.unitid.easypki.util.CertificateConverter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECPoint;

public class CertificateUtil {
    public static byte[] getFingerprint(String hashAlgorithmIdentifier, X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        Object hash = null;
        if (null == x509Certificate) {
            throw new IllegalArgumentException("x509Certificate must not be null.");
        }
        EPMessageDigest digest = EPMessageDigest.getInstance(hashAlgorithmIdentifier);
        digest.update(x509Certificate.getEncoded());
        return digest.digest();
    }

    public static byte[] getAuthorityKeyIdentifier(String cert) throws IOException, CertificateException {
        X509Certificate x509Certificate = CertificateConverter.fromBase64(cert);
        return CertificateUtil.getAuthorityKeyIdentifier(x509Certificate);
    }

    public static byte[] getAuthorityKeyIdentifier(X509Certificate cert) throws IOException {
        return CertificateUtil.getSubjectOrAuthorityKeyIdentifier(cert, "2.5.29.35");
    }

    public static byte[] getSubjectKeyIdentifier(String cert) throws IOException, CertificateException {
        X509Certificate x509Certificate = CertificateConverter.fromBase64(cert);
        return CertificateUtil.getSubjectKeyIdentifier(x509Certificate);
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate cert) throws IOException {
        byte[] keyID = null;
        try {
            keyID = CertificateUtil.getSubjectOrAuthorityKeyIdentifier(cert, "2.5.29.14");
        }
        catch (Exception e) {
            keyID = CertificateUtil.getKeyIdentifier(cert.getPublicKey());
        }
        return keyID;
    }

    public static SubjectPublicKeyInfo getSubjectPublicKeyInfo(PublicKey publicKey) throws InvalidKeyException {
        SubjectPublicKeyInfo publicKeyInfo = null;
        try {
            if ("SM2".equals(publicKey.getAlgorithm()) || "1.2.156.10197.1.301".equals(publicKey.getAlgorithm())) {
                ECPoint Q = null;
                if (publicKey instanceof SM2BCPublicKey) {
                    Q = ((SM2BCPublicKey)((Object)publicKey)).getQ();
                } else if (publicKey instanceof BCECPublicKey) {
                    BCECPublicKey ecPublicKey = (BCECPublicKey)publicKey;
                    Q = ecPublicKey.getQ();
                } else {
                    throw new InvalidKeyException("unsupported sm2 public key: " + publicKey.getClass().getName());
                }
                publicKeyInfo = CertificateUtil.buildSM2SubjectPublicKeyInfo(Q);
            } else {
                publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)((ASN1Sequence)new ASN1InputStream(publicKey.getEncoded()).readObject()));
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("fail to get subject public key info,cause:" + e.getMessage());
        }
        return publicKeyInfo;
    }

    private static SubjectPublicKeyInfo buildSM2SubjectPublicKeyInfo(ECPoint Q) {
        BigInteger x = Q.getXCoord().toBigInteger();
        BigInteger y = Q.getYCoord().toBigInteger();
        ECPoint ecPoint = ECDomainParametersHelper.getECCurve().createPoint(x, y);
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(ecPoint, false).toASN1Primitive();
        return new SubjectPublicKeyInfo(EPAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, p.getOctets());
    }

    public static byte[] getKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        byte[] keyIdentifier = null;
        try {
            DEROctetString octKeyIdentifier = new DEROctetString(CertificateUtil.sha1Digest(publicKeyInfo.getPublicKeyData().getBytes()));
            keyIdentifier = octKeyIdentifier.getOctets();
        }
        catch (Exception e) {
            throw new IOException("failed to get subject key identifier", e);
        }
        return keyIdentifier;
    }

    public static byte[] getKeyIdentifier(PublicKey publicKey) throws IOException {
        byte[] keyIdentifier = null;
        SubjectPublicKeyInfo publicKeyInfo = null;
        try {
            publicKeyInfo = CertificateUtil.getSubjectPublicKeyInfo(publicKey);
            DEROctetString octKeyIdentifier = new DEROctetString(CertificateUtil.sha1Digest(publicKeyInfo.getPublicKeyData().getBytes()));
            keyIdentifier = octKeyIdentifier.getOctets();
        }
        catch (Exception e) {
            throw new IOException("failed to get subject key identifier", e);
        }
        return keyIdentifier;
    }

    private static byte[] sha1Digest(byte[] data) {
        SHA1Digest digest = new SHA1Digest();
        byte[] value = new byte[digest.getDigestSize()];
        digest.update(data, 0, data.length);
        digest.doFinal(value, 0);
        return value;
    }

    public static String getIdentityCode(X509Certificate cert, String oid) throws IOException {
        String code;
        block5: {
            byte[] oidValue = cert.getExtensionValue(oid);
            if (null == oidValue) {
                throw new NullPointerException("\u672a\u67e5\u8be2\u5230\u8bc1\u4e66\u6269\u5c55\uff1a" + oid);
            }
            code = null;
            try {
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])oidValue);
                DEROctetString octetString = (DEROctetString)dlSequence.getObjectAt(1);
                if ("1.2.156.10260.4.1.3".equals(oid)) {
                    DERPrintableString printableString = (DERPrintableString)ASN1Primitive.fromByteArray((byte[])octetString.getOctets());
                    code = printableString.getString();
                    break block5;
                }
                if ("1.2.156.10260.4.1.1".equals(oid)) {
                    DLTaggedObject taggedObject = (DLTaggedObject)ASN1Primitive.fromByteArray((byte[])octetString.getOctets());
                    DERPrintableString printableString = (DERPrintableString)taggedObject.getObject();
                    code = printableString.getString();
                    break block5;
                }
                throw new Exception("\u4e0d\u652f\u6301\u7684\u8eab\u4efd\u6807\u8bc6OID\uff1a" + oid);
            }
            catch (Exception e) {
                throw new IOException("\u89e3\u6790OID\uff1a" + oid + "\u5f02\u5e38\uff0c\u9519\u8bef\uff1a" + e.getMessage(), e);
            }
        }
        return code;
    }

    public static byte[] getSubjectOrAuthorityKeyIdentifier(X509Certificate cert, String oid) throws IOException {
        DEROctetString keyId;
        byte[] akiValue = cert.getExtensionValue(oid);
        switch (akiValue.length) {
            case 24: {
                ASN1OctetString oct = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])akiValue);
                keyId = (DEROctetString)DEROctetString.fromByteArray((byte[])oct.getOctets());
                break;
            }
            case 26: {
                ASN1OctetString temValue = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])akiValue);
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])temValue.getOctets());
                DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                keyId = (DEROctetString)taggedObject.getObject();
                break;
            }
            case 31: {
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
                DEROctetString derTag = (DEROctetString)dlSequence.getObjectAt(1);
                keyId = (DEROctetString)DEROctetString.fromByteArray((byte[])derTag.getOctets());
                break;
            }
            case 33: {
                DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
                DEROctetString derTag = (DEROctetString)dlSequence.getObjectAt(1);
                dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])derTag.getOctets());
                DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                keyId = (DEROctetString)taggedObject.getObject();
                break;
            }
            default: {
                try {
                    DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])akiValue);
                    DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                    keyId = (DEROctetString)taggedObject.getObject();
                    break;
                }
                catch (ClassCastException ex) {
                    ASN1OctetString tempValue = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])akiValue);
                    DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])tempValue.getOctets());
                    DERTaggedObject taggedObject = (DERTaggedObject)dlSequence.getObjectAt(0);
                    keyId = (DEROctetString)taggedObject.getObject();
                }
            }
        }
        return keyId.getOctets();
    }

    public static boolean validateCertificateChain(X509Certificate entityCertificate, X509Certificate issuerCertificate) throws CertificateException {
        boolean result = false;
        if (null == entityCertificate) {
            throw new NullPointerException("entityCertificate is null");
        }
        if (null == issuerCertificate) {
            throw new NullPointerException("issuerCertificate is null");
        }
        String sigAlgOID = entityCertificate.getSigAlgOID();
        if ("1.2.156.10197.1.501".equals(sigAlgOID)) {
            try {
                SM2Signature verifier = new SM2Signature();
                verifier.initVerify(issuerCertificate);
                verifier.update(entityCertificate.getTBSCertificate());
                result = verifier.verify(entityCertificate.getSignature());
            }
            catch (Exception e) {
                throw new CertificateException("\u9a8c\u8bc1\u8bc1\u4e66\u94fe\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0:" + e.getMessage());
            }
        } else if ("1.2.840.113549.1.1.5".equals(sigAlgOID) || "1.2.840.113549.1.1.11".equals(sigAlgOID)) {
            try {
                RSASignature verifier = new RSASignature(entityCertificate.getSigAlgName());
                verifier.initVerify(issuerCertificate);
                verifier.update(entityCertificate.getTBSCertificate());
                result = verifier.verify(entityCertificate.getSignature());
            }
            catch (Exception e) {
                throw new CertificateException("\u9a8c\u8bc1\u8bc1\u4e66\u94fe\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0:" + e.getMessage());
            }
        } else {
            throw new CertificateException("\u8bc1\u4e66\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301:" + entityCertificate.getSigAlgOID());
        }
        return result;
    }
}

