/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security.sm3;

import cn.unitid.easypki.security.sm3.SM2EllipticCurveParameters;
import java.math.BigInteger;

class SM3 {
    public static final byte[] iv;
    public static int[] Tj;

    SM3() {
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM3.convert(V);
        int[] b = SM3.convert(B);
        return SM3.convert(SM3.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < arr.length; i += 4) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = SM3.bigEndianByteToInt(tmp);
        }
        return out;
    }

    private static byte[] convert(int[] ns) {
        byte[] bs = new byte[4 * ns.length];
        SM3.intToBigEndian(ns, bs, 0);
        return bs;
    }

    static void intToBigEndian(int[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            SM3.scIntToBigEndian(ns[i], bs, off);
            off += 4;
        }
    }

    static void scIntToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM3.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int ss1 = SM3.bitCycleLeft(a, 12) + e + SM3.bitCycleLeft(Tj[j], j);
            ss1 = SM3.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ SM3.bitCycleLeft(a, 12);
            int tt1 = SM3.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = SM3.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = SM3.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = SM3.bitCycleLeft(f, 19);
            f = e;
            e = SM3.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(byte[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        byte[] tmp = new byte[4];
        for (i = 0; i < B.length; i += 4) {
            for (int j = 0; j < 4; ++j) {
                tmp[j] = B[i + j];
            }
            W[i / 4] = SM3.bigEndianByteToInt(tmp);
        }
        for (i = 16; i < 68; ++i) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        return new int[][]{W, W1};
    }

    private static int[][] expand(int[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        System.arraycopy(B, 0, W, 0, B.length);
        for (i = 16; i < 68; ++i) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        return new int[][]{W, W1};
    }

    private static byte[] bigEndianIntToByte(int num) {
        return SM3.back(SM2EllipticCurveParameters.intToByte(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return SM2EllipticCurveParameters.byteToInt(SM3.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.FF1j(X, Y, Z);
        }
        return SM3.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.GG1j(X, Y, Z);
        }
        return SM3.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private static int FF2j(int X, int Y, int Z) {
        return X & Y | X & Z | Y & Z;
    }

    private static int GG1j(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private static int GG2j(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    private static int P0(int x) {
        int r9 = x << 9 | x >>> 23;
        int r17 = x << 17 | x >>> 15;
        return x ^ r9 ^ r17;
    }

    private static int P1(int x) {
        int r15 = x << 15 | x >>> 17;
        int r23 = x << 23 | x >>> 9;
        return x ^ r15 ^ r23;
    }

    static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = SM3.back(SM2EllipticCurveParameters.longToByte(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }

    public static int rotateLeft(int x, int n) {
        return x << n | x >> 32 - n;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        return n << bitLen | n >>> 32 - bitLen;
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        for (int i = 0; i < tmp.length; ++i) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
        }
        return tmp;
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    static {
        int i;
        iv = new BigInteger("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e", 16).toByteArray();
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            SM3.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            SM3.Tj[i] = 2055708042;
        }
    }
}

