/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security.ec;

import java.math.BigInteger;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class ECDomainParametersHelper {
    private static ECDomainParameters ecDomainParameters = null;
    private static ECParameterSpec params = null;
    private static ECPoint ecc_point_g;
    private static ECCurve.Fp ecc_curve;
    public static final BigInteger ecc_p;
    public static final BigInteger ecc_a;
    public static final BigInteger ecc_b;
    public static final BigInteger ecc_gx;
    public static final BigInteger ecc_gy;
    public static final BigInteger ecc_n;

    public static ECCurve getECCurve() {
        return ecc_curve;
    }

    public static ECPoint getECPointG() {
        return ecc_point_g;
    }

    public static ECDomainParameters getECDomainParameters() {
        return ecDomainParameters;
    }

    public static ECParameterSpec getECParameterSpec() {
        return params;
    }

    public static String getSM2Algorithm() {
        return "1.2.156.10197.1.301";
    }

    static {
        ecc_p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        ecc_a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        ecc_b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        ecc_gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        ecc_gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        ecc_n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        BigInteger h = BigInteger.valueOf(1L);
        ecc_curve = new ECCurve.Fp(ecc_p, ecc_a, ecc_b, null, null);
        ecc_point_g = ecc_curve.createPoint(ecc_gx, ecc_gy);
        params = new ECParameterSpec((ECCurve)ecc_curve, ecc_point_g, ecc_n, h);
        ecDomainParameters = new ECDomainParameters((ECCurve)ecc_curve, ecc_point_g, ecc_n, h);
    }
}

