/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security;

import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import cn.unitid.easypki.security.sm2.SM2;
import cn.unitid.easypki.security.sm2.SM2Result;
import cn.unitid.easypki.security.sm3.SM3Digest;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Signature {
    private byte[] userID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private int mode = 0;
    private ECPublicKey publicKey;
    private ECPrivateKey privateKey;
    private SM3Digest sm3Digest = new SM3Digest();

    public final String getAlgorithm() {
        return "1.2.156.10197.1.501";
    }

    public void update(byte[] data) throws SignatureException {
        if (data == null) {
            throw new SignatureException("data cannot be null");
        }
        if (this.mode == 0) {
            throw new SignatureException("please initialize first.");
        }
        this.sm3Digest.update(data, 0, data.length);
    }

    public void initSign(ECPrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("ECPrivateKey must not be null.");
        }
        this.privateKey = privateKey;
        if (null == this.publicKey) {
            ECPoint userKey = ECDomainParametersHelper.getECPointG().multiply(this.privateKey.getD());
            ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(userKey, ECDomainParametersHelper.getECDomainParameters());
            this.publicKey = new BCECPublicKey("1.2.156.10197.1.301", ecPublicKeyParameters, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
        }
        ECPoint Q = this.publicKey.getQ();
        BigInteger x = Q.getAffineXCoord().toBigInteger();
        BigInteger y = Q.getAffineYCoord().toBigInteger();
        this.sm3Digest.addId(x, y, this.userID);
        this.mode = 1;
    }

    public void initSign(ECPrivateKey privateKey, ECPublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("ECPublicKey must not be null.");
        }
        this.publicKey = publicKey;
        if (privateKey == null) {
            throw new NullPointerException("ECPrivateKey must not be null.");
        }
        this.privateKey = privateKey;
        ECPoint Q = this.publicKey.getQ();
        BigInteger x = Q.getAffineXCoord().toBigInteger();
        BigInteger y = Q.getAffineYCoord().toBigInteger();
        this.sm3Digest.addId(x, y, this.userID);
        this.mode = 1;
    }

    public void initVerify(ECPublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new NullPointerException("ECPublicKey should not be null.");
        }
        this.publicKey = publicKey;
        ECPoint Q = this.publicKey.getQ();
        BigInteger x = Q.getAffineXCoord().toBigInteger();
        BigInteger y = Q.getAffineYCoord().toBigInteger();
        this.sm3Digest.addId(x, y, this.userID);
        this.mode = 2;
    }

    public void initVerify(Certificate certificate) throws InvalidKeyException {
        this.initVerify((ECPublicKey)certificate.getPublicKey());
    }

    public void initUserID(String userID) {
        if (userID != null) {
            this.userID = userID.getBytes();
        }
    }

    public boolean verify(byte[] signature) throws SignatureException, InvalidKeyException {
        cn.unitid.easypki.asn1.sm2.application.SM2Signature sso = cn.unitid.easypki.asn1.sm2.application.SM2Signature.getInstance(signature);
        if (this.mode != 2) {
            throw new InvalidKeyException("please initialize certificate or public key first.");
        }
        SM2Result sm2Ret = new SM2Result();
        try {
            byte[] md = new byte[32];
            this.sm3Digest.doFinal(md, 0);
            SM2 sm2 = new SM2();
            ECPoint Q = this.publicKey.getQ();
            sm2.sm2Verify(md, Q, sso, sm2Ret);
        }
        catch (Exception e) {
            throw new SignatureException("sign error: " + e.getMessage(), e);
        }
        return sso.getR().getValue().equals(sm2Ret.R);
    }

    public byte[] sign() throws SignatureException, InvalidKeyException {
        return this.sign(null);
    }

    public byte[] sign(AsymmetricCipherKeyPair temporaryKeyPair) throws SignatureException, InvalidKeyException {
        byte[] signature;
        if (this.mode != 1) {
            throw new InvalidKeyException("please initialize private key first.");
        }
        SM2 sm2 = new SM2();
        sm2.presetTemporaryKeyPair(temporaryKeyPair);
        try {
            byte[] md = new byte[32];
            this.sm3Digest.doFinal(md, 0);
            signature = this.calculateSignature(sm2, md);
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign data");
        }
        return signature;
    }

    public byte[] digestSign(byte[] digest) throws SignatureException, InvalidKeyException {
        byte[] signature;
        if (digest == null) {
            throw new NullPointerException("digest should not be null.");
        }
        if (this.mode != 1) {
            throw new InvalidKeyException("please initialize private key first.");
        }
        try {
            SM2 sm2 = new SM2();
            signature = this.calculateSignature(sm2, digest);
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign data,error:" + e.getMessage(), e);
        }
        return signature;
    }

    private byte[] calculateSignature(SM2 sm2, byte[] md) throws IOException {
        SM2Result sm2Result = new SM2Result();
        sm2.sm2Sign(md, this.privateKey.getD(), sm2Result);
        cn.unitid.easypki.asn1.sm2.application.SM2Signature signatureObject = new cn.unitid.easypki.asn1.sm2.application.SM2Signature(sm2Result.r.toByteArray(), sm2Result.s.toByteArray());
        byte[] signature = signatureObject.toASN1Primitive().getEncoded();
        return signature;
    }
}

