/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7.envelope;

import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.SM2AsymmetricCipher;
import cn.unitid.easypki.pkcs7.envelope.OperatorHelper;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.operator.AsymmetricKeyWrapper;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OperatorException;

public class EPAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private OperatorHelper helper;
    private Map extraMappings;
    private PublicKey publicKey;
    private SecureRandom random;

    public EPAsymmetricKeyWrapper(PublicKey publicKey) {
        super("RSA".equals(publicKey.getAlgorithm()) ? new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"), null) : new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.3"), null));
        this.helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
        this.extraMappings = new HashMap();
        this.publicKey = publicKey;
    }

    public EPAsymmetricKeyWrapper(X509Certificate certificate) {
        this(certificate.getPublicKey());
    }

    protected EPAsymmetricKeyWrapper(AlgorithmIdentifier algorithmId) {
        super(algorithmId);
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        return "RSA".equals(this.publicKey.getAlgorithm()) ? this.rsaGenerateWrappedKey(encryptionKey) : this.sm2GenerateWrappedKey(encryptionKey);
    }

    private byte[] sm2GenerateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        byte[] encryptedKeyBytes = null;
        try {
            SM2AsymmetricCipher cipher = new SM2AsymmetricCipher();
            cipher.init(1, this.publicKey);
            cipher.update(this.getJceKey(encryptionKey).getEncoded());
            encryptedKeyBytes = cipher.doFinal();
        }
        catch (CipherException e) {
            throw new OperatorException("\u52a0\u5bc6\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        return encryptedKeyBytes;
    }

    private byte[] rsaGenerateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        Cipher keyEncryptionCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        AlgorithmParameters algParams = this.helper.createAlgorithmParameters(this.getAlgorithmIdentifier());
        byte[] encryptedKeyBytes = null;
        try {
            if (algParams != null) {
                keyEncryptionCipher.init(3, (Key)this.publicKey, algParams, this.random);
            } else {
                keyEncryptionCipher.init(3, (Key)this.publicKey, this.random);
            }
            encryptedKeyBytes = keyEncryptionCipher.wrap(this.getJceKey(encryptionKey));
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        if (encryptedKeyBytes == null) {
            try {
                keyEncryptionCipher.init(1, (Key)this.publicKey, this.random);
                encryptedKeyBytes = keyEncryptionCipher.doFinal(this.getJceKey(encryptionKey).getEncoded());
            }
            catch (InvalidKeyException var6) {
                throw new OperatorException("unable to encrypt contents key", (Throwable)var6);
            }
            catch (GeneralSecurityException var7) {
                throw new OperatorException("unable to encrypt contents key", (Throwable)var7);
            }
        }
        return encryptedKeyBytes;
    }

    private Key getJceKey(GenericKey key) {
        if (key.getRepresentation() instanceof Key) {
            return (Key)key.getRepresentation();
        }
        if (key.getRepresentation() instanceof byte[]) {
            return new SecretKeySpec((byte[])key.getRepresentation(), "ENC");
        }
        throw new IllegalArgumentException("unknown generic key type");
    }
}

