/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs12;

import cn.unitid.easypki.crypto.ECKeyGenerator;
import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import cn.unitid.easypki.util.CertificateConverter;
import cn.unitid.easypki.x509.SM2X509Certificate;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCS12SafeBagFactory;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilderProvider;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEInputDecryptorProviderBuilder;

public class SM2KeyStore {
    private List<X509Certificate> certificateList;
    private ECPrivateKey privateKey;
    private ECPoint ecPointQ;
    private Map<ECPoint, X509Certificate> certificateMap = new HashMap<ECPoint, X509Certificate>();

    public SM2KeyStore() {
        this.certificateList = new ArrayList<X509Certificate>();
    }

    public void loadKeyStore(byte[] pfxBinary, char[] password) throws KeyStoreException {
        Pfx pfx = Pfx.getInstance((Object)pfxBinary);
        PKCS12PfxPdu pdu = new PKCS12PfxPdu(pfx);
        BcPKCS12MacCalculatorBuilderProvider macCalcProviderBuilder = new BcPKCS12MacCalculatorBuilderProvider(BcDefaultDigestProvider.INSTANCE);
        try {
            if (!pdu.isMacValid((PKCS12MacCalculatorBuilderProvider)macCalcProviderBuilder, password)) {
                throw new Exception("invalid password!");
            }
            ContentInfo[] contentInfos = pdu.getContentInfos();
            BcPKCS12PBEInputDecryptorProviderBuilder idpBuilder = new BcPKCS12PBEInputDecryptorProviderBuilder();
            InputDecryptorProvider inputDecryptorProvider = idpBuilder.build(password);
            for (ContentInfo contentInfo : contentInfos) {
                ASN1ObjectIdentifier oid = contentInfo.getContentType();
                if (oid.equals((ASN1Primitive)PKCSObjectIdentifiers.encryptedData)) {
                    this.parseCertificate(contentInfo, inputDecryptorProvider);
                    continue;
                }
                if (!oid.equals((ASN1Primitive)PKCSObjectIdentifiers.data)) continue;
                this.privateKey = this.parsePrivateKey(contentInfo, inputDecryptorProvider);
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("fail to load key store, cause:" + e.getMessage());
        }
    }

    public List<X509Certificate> getCertificateList() {
        return this.certificateList;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getX509Certificate() {
        return this.certificateMap.get(this.ecPointQ);
    }

    private void parseCertificate(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException, IOException, CertificateException {
        PKCS12SafeBag[] safeBags;
        X509Certificate x509Certificate = null;
        PKCS12SafeBagFactory factory = new PKCS12SafeBagFactory(contentInfo, inputDecryptorProvider);
        for (PKCS12SafeBag sfb : safeBags = factory.getSafeBags()) {
            if (!sfb.getType().equals((ASN1Primitive)PKCSObjectIdentifiers.certBag)) continue;
            X509CertificateHolder certificateHolder = (X509CertificateHolder)sfb.getBagValue();
            x509Certificate = CertificateConverter.fromBinary(certificateHolder.getEncoded());
            SM2X509Certificate sm2X509Certificate = (SM2X509Certificate)x509Certificate;
            this.certificateMap.put(((SM2BCPublicKey)((Object)sm2X509Certificate.getPublicKey())).getQ(), x509Certificate);
            this.certificateList.add(x509Certificate);
        }
    }

    private ECPrivateKey parsePrivateKey(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException, IOException, InvalidKeyException {
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)((ASN1OctetString)contentInfo.getContent()).getOctets());
        SafeBag sb = SafeBag.getInstance((Object)sequence.getObjectAt(0));
        EncryptedPrivateKeyInfo encInfo = EncryptedPrivateKeyInfo.getInstance((Object)sb.getBagValue());
        PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(encInfo);
        PrivateKeyInfo privateKeyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
        BCECPrivateKey privateKey = ECKeyGenerator.generate(ASN1Sequence.getInstance((Object)privateKeyInfo.getEncoded()));
        this.ecPointQ = ECDomainParametersHelper.getECPointG().multiply(privateKey.getD());
        return privateKey;
    }
}

