/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class RSAKeyStore {
    private static KeyStore keyStore = null;
    private char[] pin = null;

    public RSAKeyStore() {
        this.initialize();
    }

    public RSAKeyStore(String type) {
        try {
            keyStore = KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        try {
            keyStore = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadKeyStore(InputStream input, char[] pin) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.pin = pin;
        keyStore.load(input, pin);
    }

    public List<X509Certificate> getCertificateChain() throws KeyStoreException {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        Enumeration<String> enu = keyStore.aliases();
        while (enu.hasMoreElements()) {
            String alias = enu.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            for (Certificate cert : keyStore.getCertificateChain(alias)) {
                chain.add((X509Certificate)cert);
            }
        }
        return chain.size() > 0 ? chain : null;
    }

    public X509Certificate getCertificate() throws KeyStoreException {
        Certificate cert = null;
        Enumeration<String> enu = keyStore.aliases();
        while (enu.hasMoreElements()) {
            String alias = enu.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            cert = keyStore.getCertificate(alias);
            break;
        }
        return (X509Certificate)cert;
    }

    public PrivateKey getPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String alias;
        PrivateKey prvKey = null;
        Enumeration<String> enu = keyStore.aliases();
        while (enu.hasMoreElements() && (!keyStore.isKeyEntry(alias = enu.nextElement()) || (prvKey = (PrivateKey)keyStore.getKey(alias, this.pin)) == null)) {
        }
        return prvKey;
    }
}

