/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.operator;

import cn.unitid.easypki.security.SM2Signature;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.operator.ContentSigner;

public class BCSM2PrivateKeyContentSigner
implements ContentSigner {
    private final AlgorithmIdentifier algorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.501"), (ASN1Encodable)DERNull.INSTANCE);
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private ByteArrayOutputStream outputStream = null;
    private AsymmetricCipherKeyPair temporaryKeyPair;

    public BCSM2PrivateKeyContentSigner(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
        this.outputStream = new ByteArrayOutputStream();
    }

    public BCSM2PrivateKeyContentSigner(ECPrivateKey privateKey, ECPublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.outputStream = new ByteArrayOutputStream();
    }

    private BCSM2PrivateKeyContentSigner() {
    }

    public void presetTemporaryKeyPair(AsymmetricCipherKeyPair temporaryKeyPair) {
        this.temporaryKeyPair = temporaryKeyPair;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithm;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public byte[] getSignature() {
        byte[] signature = null;
        byte[] data = this.outputStream.toByteArray();
        try {
            SM2Signature sm2Signature = new SM2Signature();
            if (this.publicKey != null) {
                sm2Signature.initSign(this.privateKey, this.publicKey);
            } else {
                sm2Signature.initSign(this.privateKey);
            }
            sm2Signature.update(data);
            signature = this.temporaryKeyPair != null ? sm2Signature.sign(this.temporaryKeyPair) : sm2Signature.sign();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return signature;
    }
}

