/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.crypto;

import cn.unitid.easypki.asn1.ec.ECParameters;
import cn.unitid.easypki.asn1.sm2.application.EnvelopedRSAKeyBlob;
import cn.unitid.easypki.asn1.sm2.application.EnvelopedSM2KeyBlob;
import cn.unitid.easypki.asn1.sm2.application.SM2EnvelopedKey;
import cn.unitid.easypki.asn1.sm2.syntax.ECPrivateKey;
import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.ECKeyGenerator;
import cn.unitid.easypki.crypto.SM2AsymmetricCipher;
import cn.unitid.easypki.crypto.SM4SymmetricCipher;
import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.util.CertificateConverter;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.util.encoders.Base64;

public class EncryptionPrivateKeyDecryptor {
    private final String SM2_ALGORITHM = "SM2";

    public BCECPrivateKey decrypt(PrivateKey signaturePrivateKey, SM2EnvelopedKey sm2EnvelopedKey) throws CipherException {
        BCECPrivateKey ecPrivateKey = null;
        byte[] symmKey = null;
        try {
            SM2AsymmetricCipher cipher = new SM2AsymmetricCipher();
            cipher.init(2, signaturePrivateKey);
            cipher.update(sm2EnvelopedKey.getSymEncryptedKey().getEncoded());
            symmKey = cipher.doFinal();
        }
        catch (IOException e) {
            throw new CipherException("\u89e3\u5bc6\u5bf9\u79f0\u5bc6\u94a5\u5931\u8d25\uff0c" + e.getMessage());
        }
        try {
            SM4SymmetricCipher sm4SymmetricCipher = new SM4SymmetricCipher("ECB");
            sm4SymmetricCipher.init(2, symmKey);
            sm4SymmetricCipher.update(sm2EnvelopedKey.getSM2EncryptedPrivateKey().getBytes());
            byte[] encPrivateKeyBinary = sm4SymmetricCipher.doFinal();
            ecPrivateKey = ECKeyGenerator.generateByUserD(encPrivateKeyBinary);
        }
        catch (InvalidKeyException e) {
            throw new CipherException("\u89e3\u5bc6\u52a0\u5bc6\u5bc6\u94a5\u5931\u8d25\uff0c" + e.getMessage());
        }
        return ecPrivateKey;
    }

    public byte[] decrypt(PrivateKey signaturePrivateKey, String encryptionCertificate, String encryptionPrivateKeyBlob) throws CertificateException, CipherException {
        X509Certificate x509Certificate = CertificateConverter.fromBase64(encryptionCertificate);
        return this.decrypt(signaturePrivateKey, x509Certificate.getPublicKey(), encryptionPrivateKeyBlob);
    }

    public byte[] decrypt(PrivateKey signaturePrivateKey, PublicKey publicKey, String encryptionPrivateKeyBlob) throws CertificateException, CipherException {
        byte[] privateKey;
        block9: {
            byte[] encryptedData;
            byte[] symmKey;
            privateKey = null;
            byte[] envelopedKeyBlob = Base64.decode((String)encryptionPrivateKeyBlob);
            String algo = publicKey.getAlgorithm();
            int symmAlgoID = -1;
            SM2BCPublicKey ecPublicKey = null;
            try {
                if ("SM2".equals(algo) || "1.2.156.10197.1.301".equals(algo)) {
                    EnvelopedSM2KeyBlob sm2KeyBlob = EnvelopedSM2KeyBlob.getInstance(envelopedKeyBlob);
                    symmKey = this.decryptByPrivateKey(sm2KeyBlob.getWrappedKey().getEncoded(), algo, signaturePrivateKey);
                    encryptedData = sm2KeyBlob.getEncryptedPrivateKey();
                    symmAlgoID = sm2KeyBlob.getSymmAlgID();
                    ecPublicKey = sm2KeyBlob.getECPublicKey();
                } else {
                    EnvelopedRSAKeyBlob rsaKeyBlob = EnvelopedRSAKeyBlob.getInstance(envelopedKeyBlob);
                    symmKey = this.decryptByPrivateKey(rsaKeyBlob.getWrappedKey(), algo, signaturePrivateKey);
                    encryptedData = rsaKeyBlob.getEncryptedData();
                    symmAlgoID = rsaKeyBlob.getSymmAlgID();
                }
            }
            catch (Exception e) {
                throw new CipherException("\u89e3\u5bc6\u52a0\u5bc6\u79c1\u94a5\u6570\u5b57\u4fe1\u5c01\u5931\u8d25\uff01" + e.getMessage(), e);
            }
            try {
                if (symmAlgoID == 1025) {
                    SM4SymmetricCipher sm4SymmetricCipher = new SM4SymmetricCipher("ECB");
                    sm4SymmetricCipher.init(2, symmKey);
                    sm4SymmetricCipher.update(encryptedData);
                    if ("SM2".equals(algo) || "1.2.156.10197.1.301".equals(algo)) {
                        byte[] userD = sm4SymmetricCipher.doFinal();
                        SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(ecPublicKey.getQ());
                        ECPrivateKey ecPrivateKey = new ECPrivateKey(userD, new ECParameters(new ASN1ObjectIdentifier("1.2.156.10197.1.301")), sm2BCPublicKey.getEncoded());
                        privateKey = ecPrivateKey.getEncoded();
                    } else {
                        privateKey = sm4SymmetricCipher.doFinal();
                    }
                    break block9;
                }
                throw new Exception("\u89e3\u5bc6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25\uff01\u5bf9\u79f0\u5bc6\u94a5\u6807\u8bc6ID\u9519\u8bef:" + symmAlgoID);
            }
            catch (Exception e) {
                throw new CipherException("\u89e3\u5bc6\u52a0\u5bc6\u79c1\u94a5\u5931\u8d25\uff01" + e.getMessage(), e);
            }
        }
        return privateKey;
    }

    private byte[] decryptByPrivateKey(byte[] data, String algo, PrivateKey signaturePrivateKey) throws CipherException {
        byte[] decryptedData = null;
        try {
            if (algo.equalsIgnoreCase("SM2") || algo.equals("1.2.156.10197.1.301")) {
                SM2AsymmetricCipher cipher = new SM2AsymmetricCipher();
                cipher.init(2, signaturePrivateKey);
                cipher.update(data);
                decryptedData = cipher.doFinal();
            } else {
                Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
                cipher.init(2, signaturePrivateKey);
                cipher.update(data);
                decryptedData = cipher.doFinal();
            }
        }
        catch (Exception e) {
            throw new CipherException("\u89e3\u5bc6\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return decryptedData;
    }
}

