/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.crypto;

import cn.unitid.easypki.asn1.sm2.application.SM2PrivateKey;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;

public class ECKeyGenerator {
    private ECKeyGenerator() {
    }

    public static BCECPrivateKey generate(SM2PrivateKey sm2PrivateKey) {
        if (sm2PrivateKey == null) {
            throw new NullPointerException("parameter cannot be null.");
        }
        ASN1Integer userD = ASN1Integer.getInstance((Object)((Object)sm2PrivateKey));
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(userD.getPositiveValue(), ECDomainParametersHelper.getECDomainParameters());
        BCECPrivateKey privateKey = new BCECPrivateKey("1.2.156.10197.1.301", ecPrivateKeyParameters, BouncyCastleProvider.CONFIGURATION);
        return privateKey;
    }

    public static BCECPrivateKey generateByUserD(SM2PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new IllegalArgumentException("private key must not be null.");
        }
        return ECKeyGenerator.generateByUserD(privateKey.toBigInteger().toByteArray());
    }

    public static BCECPrivateKey generateByUserD(byte[] userD) throws InvalidKeyException {
        BCECPrivateKey privateKey = null;
        try {
            BigInteger d = new BigInteger(userD);
            if (-1 == d.signum()) {
                d = new BigInteger(1, userD);
            }
            ECPoint ecPointQ = ECDomainParametersHelper.getECPointG().multiply(d);
            ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(ecPointQ, ECDomainParametersHelper.getECDomainParameters());
            BCECPublicKey publicKey = new BCECPublicKey("1.2.156.10197.1.301", ecPublicKeyParameters, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
            ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(d, ECDomainParametersHelper.getECDomainParameters());
            privateKey = new BCECPrivateKey("1.2.156.10197.1.301", ecPrivateKeyParameters, publicKey, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
        return privateKey;
    }

    public static BCECPrivateKey generate(byte[] syanSM2PrivateKey) throws InvalidKeyException {
        return ECKeyGenerator.generate(ASN1Sequence.getInstance((Object)syanSM2PrivateKey));
    }

    public static BCECPrivateKey generate(ASN1Sequence syanSM2PrivateKey) throws InvalidKeyException {
        BCECPrivateKey privateKey = null;
        try {
            DEROctetString octetValue = (DEROctetString)DEROctetString.getInstance((Object)syanSM2PrivateKey.getObjectAt(2));
            ASN1Sequence pkSequence = ASN1Sequence.getInstance((Object)octetValue.getOctets());
            DEROctetString sm2PrivateKeyValue = null;
            Enumeration enu = pkSequence.getObjects();
            while (enu.hasMoreElements()) {
                Object obj = enu.nextElement();
                if (!(obj instanceof DEROctetString)) continue;
                sm2PrivateKeyValue = (DEROctetString)obj;
            }
            BigInteger userD = null;
            if (sm2PrivateKeyValue != null) {
                userD = new BigInteger(1, sm2PrivateKeyValue.getOctets());
            }
            ECPoint ecPointQ = ECDomainParametersHelper.getECPointG().multiply(userD);
            ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(ecPointQ, ECDomainParametersHelper.getECDomainParameters());
            BCECPublicKey publicKey = new BCECPublicKey("1.2.156.10197.1.301", ecPublicKeyParameters, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
            ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(userD, ECDomainParametersHelper.getECDomainParameters());
            privateKey = new BCECPrivateKey("1.2.156.10197.1.301", ecPrivateKeyParameters, publicKey, ECDomainParametersHelper.getECParameterSpec(), BouncyCastleProvider.CONFIGURATION);
        }
        catch (Exception ex) {
            throw new InvalidKeyException("failed to build syan ec private key, cause: " + ex.getMessage());
        }
        return privateKey;
    }

    public static BCECPrivateKey generate(BigInteger userD) throws InvalidKeyException {
        if (userD.signum() < 1) {
            throw new InvalidKeyException("userD MUST be positive integer");
        }
        BCECPrivateKey privateKey = null;
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(userD, ECDomainParametersHelper.getECDomainParameters());
        privateKey = new BCECPrivateKey("1.2.156.10197.1.301", ecPrivateKeyParameters, BouncyCastleProvider.CONFIGURATION);
        return privateKey;
    }
}

