/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    public SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = r;
        this.s = s;
    }

    public SM2Signature(byte[] r, byte[] s) {
        this.r = new ASN1Integer(new BigInteger(1, r));
        this.s = new ASN1Integer(new BigInteger(1, s));
    }

    private SM2Signature(ASN1Sequence seq) {
        this.r = new ASN1Integer(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue());
        this.s = new ASN1Integer(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getPositiveValue());
    }

    public static SM2Signature getInstance(Object o) {
        if (o instanceof SM2Signature) {
            return (SM2Signature)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new SM2Signature(ASN1Sequence.getInstance((Object)o));
        }
        if (o instanceof byte[]) {
            return new SM2Signature(ASN1Sequence.getInstance((Object)o));
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public byte[] getByteR() {
        return this.processASN1Integer(this.r);
    }

    public byte[] getByteS() {
        return this.processASN1Integer(this.s);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.r);
        v.add((ASN1Encodable)this.s);
        return new DERSequence(v);
    }

    public String toString() {
        String TAB = "\n\t";
        StringBuilder buff = new StringBuilder("SM2Signature::{\n\t");
        buff.append("r=");
        buff.append(this.r);
        buff.append(TAB);
        buff.append("s=");
        buff.append(this.s);
        buff.append("\n}");
        return buff.toString();
    }

    private byte[] processASN1Integer(ASN1Integer num) {
        byte[] value = num.getValue().toByteArray();
        byte[] rv = null;
        if (32 == value.length) {
            rv = value;
        } else if (33 == value.length) {
            rv = new byte[32];
            System.arraycopy(value, 1, rv, 0, 32);
        } else {
            throw new IllegalStateException("R or S`s byte length must be 32 or 33 !");
        }
        return rv;
    }

    private byte[] delZeros(byte[] content) {
        int zeroNumber = 0;
        for (int i = 31; i >= 0 && content[i] == 0; --i) {
            ++zeroNumber;
        }
        return Arrays.copyOf(content, 32 - zeroNumber);
    }
}

