/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;

public class SM2PublicKey
extends ASN1Object {
    private DERBitString sm2PublicKey;

    public SM2PublicKey(byte[] sm2PubKey) {
        this.sm2PublicKey = new DERBitString(sm2PubKey);
    }

    public SM2PublicKey(byte[] x, byte[] y) {
        byte[] sm2Key = new byte[x.length + y.length + 1];
        sm2Key[0] = 4;
        System.arraycopy(x, 0, sm2Key, 1, x.length);
        System.arraycopy(y, 0, sm2Key, 1 + x.length, y.length);
        this.sm2PublicKey = new DERBitString(sm2Key);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.sm2PublicKey;
    }

    public byte[] getOctets() {
        return this.sm2PublicKey.getOctets();
    }
}

