/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import cn.unitid.easypki.asn1.rsa.RSAEnvelopedKey;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EnvelopedRSAKeyBlob {
    private int symmAlgID;
    private int wrappedKeyLen;
    private byte[] wrappedKey;
    private int encryptedDataLen;
    private byte[] encryptedData;
    final int SYMMALGID_LEN = 4;
    final int WRAPPEDKEYLEN_LEN = 4;
    final int WRAPPEDKEY_LEN = 1024;
    final int ENCRYPTEDDATALEN_LEN = 4;

    public static EnvelopedRSAKeyBlob getInstance(Object envelopedKeyBlob) throws GeneralSecurityException {
        if (envelopedKeyBlob instanceof ASN1Sequence) {
            return new EnvelopedRSAKeyBlob((ASN1Sequence)envelopedKeyBlob);
        }
        if (envelopedKeyBlob instanceof byte[]) {
            return new EnvelopedRSAKeyBlob((byte[])envelopedKeyBlob);
        }
        throw new IllegalArgumentException("unknown enveloped key blob:" + envelopedKeyBlob.getClass().getName());
    }

    private EnvelopedRSAKeyBlob(ASN1Sequence sequence) {
        RSAEnvelopedKey envelopedKey = RSAEnvelopedKey.getInstance(sequence);
        AlgorithmIdentifier symmAlgoID = envelopedKey.getSymAlgoID();
        this.symmAlgID = symmAlgoID.getAlgorithm().getId().startsWith("1.2.156.10197.1.104") ? 1025 : -127;
        this.wrappedKey = envelopedKey.getSymEncryptedKey().getOctets();
        this.wrappedKeyLen = this.wrappedKey.length;
        this.encryptedData = envelopedKey.getSymEncryptedKey().getOctets();
        this.encryptedDataLen = this.encryptedData.length;
    }

    public EnvelopedRSAKeyBlob(byte[] envelopedKeyBlob) throws GeneralSecurityException {
        try {
            byte[] ulSymmAlgID = new byte[4];
            System.arraycopy(envelopedKeyBlob, 0, ulSymmAlgID, 0, 4);
            this.symmAlgID = ByteBuffer.wrap(ulSymmAlgID).order(ByteOrder.LITTLE_ENDIAN).getInt();
            byte[] ulWrappedKeyLen = new byte[4];
            System.arraycopy(envelopedKeyBlob, 4, ulWrappedKeyLen, 0, 4);
            this.wrappedKeyLen = ByteBuffer.wrap(ulWrappedKeyLen).order(ByteOrder.LITTLE_ENDIAN).getInt();
            this.wrappedKey = new byte[this.wrappedKeyLen];
            System.arraycopy(envelopedKeyBlob, 8, this.wrappedKey, 0, this.wrappedKeyLen);
            byte[] ulEncryptedDataLen = new byte[4];
            System.arraycopy(envelopedKeyBlob, 1032, ulEncryptedDataLen, 0, 4);
            this.encryptedDataLen = ByteBuffer.wrap(ulEncryptedDataLen).order(ByteOrder.LITTLE_ENDIAN).getInt();
            this.encryptedData = new byte[this.encryptedDataLen];
            System.arraycopy(envelopedKeyBlob, 1036, this.encryptedData, 0, this.encryptedData.length);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("fail to parse EnvelopedRSAKeyBlob, cause:" + e.getMessage(), e);
        }
    }

    public int getSymmAlgID() {
        return this.symmAlgID;
    }

    public byte[] getWrappedKey() {
        return this.wrappedKey;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }
}

