/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.slf4j;

import cfca.org.slf4j.IMarkerFactory;
import cfca.org.slf4j.Marker;
import cfca.org.slf4j.helpers.BasicMarkerFactory;
import cfca.org.slf4j.helpers.Util;
import cfca.org.slf4j.impl.StaticMarkerBinder;

public class MarkerFactory {
    static IMarkerFactory MARKER_FACTORY;

    static {
        try {
            MARKER_FACTORY = MarkerFactory.bwCompatibleGetMarkerFactoryFromBinder();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            MARKER_FACTORY = new BasicMarkerFactory();
        }
        catch (Exception e) {
            Util.report("Unexpected failure while binding MarkerFactory", e);
        }
    }

    private MarkerFactory() {
    }

    private static IMarkerFactory bwCompatibleGetMarkerFactoryFromBinder() throws NoClassDefFoundError {
        try {
            return StaticMarkerBinder.getSingleton().getMarkerFactory();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return StaticMarkerBinder.SINGLETON.getMarkerFactory();
        }
    }

    public static Marker getMarker(String name) {
        return MARKER_FACTORY.getMarker(name);
    }

    public static Marker getDetachedMarker(String name) {
        return MARKER_FACTORY.getDetachedMarker(name);
    }

    public static IMarkerFactory getIMarkerFactory() {
        return MARKER_FACTORY;
    }
}

