/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.classic.util;

import cfca.ch.qos.logback.classic.BasicConfigurator;
import cfca.ch.qos.logback.classic.Logger;
import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.JoranConfigurator;
import cfca.ch.qos.logback.classic.spi.Configurator;
import cfca.ch.qos.logback.classic.util.EnvUtil;
import cfca.ch.qos.logback.core.LogbackException;
import cfca.ch.qos.logback.core.joran.spi.JoranException;
import cfca.ch.qos.logback.core.util.Loader;
import cfca.ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback-cfca.xml";
    public static final String LOGBACK_PROPERTIES = "logback.properties";
    private static Properties pps = new Properties();
    private static String errorInfo = "";
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public void configureByResource(URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String urlString = url.toString();
        if (!urlString.endsWith("xml")) {
            throw new LogbackException("Unexpected filename extension of file [" + url.toString() + "]. Should be either .groovy or .xml");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(this.loggerContext);
        configurator.doConfigure(url);
    }

    void joranConfigureByResource(URL url) throws JoranException {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(this.loggerContext);
        configurator.doConfigure(url);
    }

    public URL findURLOfDefaultConfigurationFile(boolean updateStatus) {
        File file;
        String customFile = null;
        URL url = null;
        URL propertyURL = null;
        ClassLoader myClassLoader = Loader.getClassLoaderOfObject(this);
        try {
            propertyURL = ContextInitializer.class.getClassLoader().getResource(LOGBACK_PROPERTIES);
            pps.load(propertyURL.openStream());
            customFile = pps.getProperty("customAbsoluteFile");
        }
        catch (Exception e) {
            errorInfo = e.getMessage();
        }
        if (!customFile.trim().equals("") && (file = new File(customFile)).exists() && file.isFile()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                errorInfo = "[" + customFile + "] cannot be loaded! " + e.getMessage();
            }
        }
        if (url == null) {
            if (!customFile.trim().equals("")) {
                errorInfo = "[" + customFile + "] cannot be loaded!";
            }
            url = Loader.getResource(AUTOCONFIG_FILE, myClassLoader);
        }
        return url;
    }

    public void autoConfig() throws JoranException {
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        URL url = this.findURLOfDefaultConfigurationFile(true);
        if (url != null) {
            this.configureByResource(url);
        } else {
            Configurator c = EnvUtil.loadFromServiceLoader(Configurator.class);
            if (c != null) {
                try {
                    c.setContext(this.loggerContext);
                    c.configure(this.loggerContext);
                }
                catch (Exception e) {
                    throw new LogbackException(String.format("Failed to initialize Configurator: %s using ServiceLoader", c != null ? c.getClass().getCanonicalName() : "null"), e);
                }
            } else {
                BasicConfigurator basicConfigurator = new BasicConfigurator();
                basicConfigurator.setContext(this.loggerContext);
                basicConfigurator.configure(this.loggerContext);
            }
        }
        try {
            Logger logger = this.loggerContext.getLogger(ContextInitializer.class);
            if (!errorInfo.equals("")) {
                logger.error(errorInfo);
            }
            if (logger.isInfoEnabled()) {
                logger.info("load configuration from " + url);
            }
        }
        catch (Exception exception) {}
    }
}

