/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x500.style.BCStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class X509CertGenerator {
    static final Logger logger = LoggerFactory.getLogger(X509CertGenerator.class);
    private Mechanism mechanism = null;
    private V3TBSCertificateGenerator tbsCertGen = new V3TBSCertificateGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private String subject = null;
    private String issuer = null;
    private BigInteger serialNumber = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private PublicKey pubKey = null;
    private DERBitString signature = null;
    private TBSCertificate tbsCert = null;
    private Hashtable extensionSet = new Hashtable();

    public void setSerialNumber(String serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        this.setSerialNumber(new BigInteger(serialNumber, 16));
    }

    public void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSerialNumber>>>>>>Running: serialNumber=" + SADKDebugger.dump(serialNumber));
        }
        if (serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        this.serialNumber = serialNumber;
        this.tbsCertGen.setSerialNumber(new ASN1Integer(serialNumber));
        if (logger.isDebugEnabled()) {
            logger.debug("setSerialNumber<<<<<<Finished");
        }
    }

    public void setSubject(String subjectDN) throws PKIException {
        this.setSubject(BCStyle.INSTANCE, subjectDN);
    }

    public void setSubject(X500NameStyle style, String subjectDN) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSubject>>>>>>Running: subjectDN=" + subjectDN + ",style=" + style);
        }
        if (style == null) {
            throw new PKIException("style is null");
        }
        if (subjectDN == null || subjectDN.trim().length() == 0) {
            throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
        }
        this.subject = subjectDN;
        this.tbsCertGen.setSubject(new X500Name(style, subjectDN));
        if (logger.isDebugEnabled()) {
            logger.debug("setSubject<<<<<<Finished");
        }
    }

    public void setIssuer(String issuerDN) throws PKIException {
        this.setIssuer(BCStyle.INSTANCE, issuerDN);
    }

    public void setIssuer(X500NameStyle style, String issuerDN) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setIssuer>>>>>>Running: issuerDN=" + issuerDN + ",style=" + style);
        }
        if (style == null) {
            throw new PKIException("style is null");
        }
        if (issuerDN == null || issuerDN.trim().length() == 0) {
            throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
        }
        this.issuer = issuerDN;
        this.tbsCertGen.setIssuer(new X500Name(style, issuerDN));
        if (logger.isDebugEnabled()) {
            logger.debug("setIssuer<<<<<<Finished");
        }
    }

    public void setNotBefore(Date notBefore) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setNotBefore>>>>>>Running: notBefore=" + notBefore);
        }
        if (notBefore == null) {
            throw new PKIException(PKIException.NOT_BEFORE_NULL, PKIException.NOT_BEFORE_NULL_DES);
        }
        this.notBefore = notBefore;
        this.tbsCertGen.setStartDate(new Time(notBefore));
        if (logger.isDebugEnabled()) {
            logger.debug("setNotBefore<<<<<<Finished");
        }
    }

    public void setNotAfter(Date notAfter) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setNotAfter>>>>>>Running: notAfter=" + notAfter);
        }
        if (notAfter == null) {
            throw new PKIException(PKIException.NOT_AFTER_NULL, PKIException.NOT_AFTER_NULL_DES);
        }
        this.notAfter = notAfter;
        this.tbsCertGen.setEndDate(new Time(notAfter));
        if (logger.isDebugEnabled()) {
            logger.debug("setNotAfter<<<<<<Finished");
        }
    }

    public void setPublicKey(PublicKey publicKey) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setPublicKey>>>>>>Running: publicKey=" + SADKDebugger.dump(publicKey));
        }
        try {
            if (publicKey == null) {
                throw new PKIException(PKIException.PUB_KEY_NULL, PKIException.PUB_KEY_NULL_DES);
            }
            this.pubKey = publicKey;
            SubjectPublicKeyInfo spki = null;
            try {
                spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.PARSER + PKIException.KEY_SPKI, PKIException.KEY_SPKI_DES, ex);
            }
            this.tbsCertGen.setSubjectPublicKeyInfo(spki);
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("setPublicKey<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("setPublicKey<<<<<<Failure", e);
            }
            throw new PKIException("setPublicKey Failure: " + e.getMessage(), e);
        }
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSignatureAlg>>>>>>Running: signatureAlgorithm=" + signatureAlgorithm);
        }
        try {
            if (signatureAlgorithm == null) {
                throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
            }
            this.mechanism = Mechanisms.signMechanismFrom(signatureAlgorithm);
            if (this.mechanism == null) {
                throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ": " + signatureAlgorithm);
            }
            ASN1ObjectIdentifier oid = Mechanism.getObjectIdentifier(signatureAlgorithm);
            this.sigAlg = new AlgorithmIdentifier(oid, DERNull.INSTANCE);
            this.tbsCertGen.setSignature(this.sigAlg);
            if (logger.isDebugEnabled()) {
                logger.debug("setSignatureAlg<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("setSignatureAlg<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("setSignatureAlg<<<<<<Failure", e);
            }
            throw new PKIException("setSignatureAlg Failure: " + e.getMessage(), e);
        }
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (logger.isDebugEnabled()) {
            logger.debug("setIssuerUniqueID>>>>>>Running: issuerUniqueID=" + SADKDebugger.dump(issuerUniqueID));
        }
        if (issuerUniqueID != null) {
            this.tbsCertGen.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setIssuerUniqueID<<<<<<Finished");
        }
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID) {
        if (logger.isDebugEnabled()) {
            logger.debug("setSubjectUniqueID>>>>>>Running: subjectUniqueID=" + SADKDebugger.dump(subjectUniqueID));
        }
        if (subjectUniqueID != null) {
            this.tbsCertGen.setSubjectUniqueID(new DERBitString(subjectUniqueID));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setSubjectUniqueID<<<<<<Finished");
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("addExtension>>>>>>Running: extension=" + SADKDebugger.dump(extension));
        }
        ASN1ObjectIdentifier derOID = extension.getExtnId();
        this.extensionSet.put(derOID, extension);
        if (logger.isDebugEnabled()) {
            logger.debug("addExtension<<<<<<Finished");
        }
    }

    private Extensions generaterExtensions() {
        if (logger.isDebugEnabled()) {
            logger.debug("generaterExtensions::>>>>>>Running: ");
        }
        Extensions extensions = null;
        if (this.extensionSet != null) {
            Iterator itor = this.extensionSet.entrySet().iterator();
            Vector v = new Vector();
            while (itor.hasNext()) {
                Map.Entry entryt = itor.next();
                v.add(entryt.getValue());
            }
            Extension[] extensionArray = new Extension[v.size()];
            v.toArray(extensionArray);
            extensions = new Extensions(extensionArray);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("generaterExtensions::<<<<<<Finished: extensions=" + SADKDebugger.dump(extensions));
        }
        return extensions;
    }

    public byte[] generateX509Cert(PrivateKey privateKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("generateX509Cert>>>>>>Running: session=" + SADKDebugger.dump(session));
        }
        try {
            if (this.issuer == null || this.issuer.trim().length() == 0) {
                throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
            }
            if (this.subject == null || this.subject.trim().length() == 0) {
                throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
            }
            if (this.pubKey == null) {
                throw new PKIException(PKIException.PUB_KEY_NULL, PKIException.PUB_KEY_NULL_DES);
            }
            if (this.sigAlg == null) {
                throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
            }
            if (this.serialNumber == null) {
                throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
            }
            if (this.notBefore == null) {
                throw new PKIException(PKIException.NOT_BEFORE_NULL, PKIException.NOT_BEFORE_NULL_DES);
            }
            if (this.notAfter == null) {
                throw new PKIException(PKIException.NOT_AFTER_NULL, PKIException.NOT_AFTER_NULL_DES);
            }
            this.generateSignature(privateKey, session);
            byte[] certBytes = this.constructCertificate();
            if (logger.isDebugEnabled()) {
                logger.debug("generateX509Cert<<<<<<Finished: certBytes=" + SADKDebugger.dump(certBytes));
            }
            return certBytes;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateX509Cert<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateX509Cert<<<<<<Failure", e);
            }
            throw new PKIException("generateX509Cert Failure: " + e.getMessage(), e);
        }
    }

    private void generateSignature(PrivateKey privateKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("generateSignature::>>>>>>Running: session=" + SADKDebugger.dump(session));
        }
        try {
            if (this.extensionSet.size() > 0) {
                this.tbsCertGen.setExtensions(this.generaterExtensions());
            }
            this.tbsCert = this.tbsCertGen.generateTBSCertificate();
            byte[] bTBSCert = null;
            try {
                bTBSCert = ASN1Parser.parseDERObj2Bytes(this.tbsCert);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.TBSCERT_BYTES, PKIException.TBSCERT_BYTES_DES, ex);
            }
            byte[] signatureData = null;
            try {
                signatureData = session.sign(this.mechanism, privateKey, bTBSCert);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
            }
            byte[] signatureBytes = null;
            if ("SM2".equalsIgnoreCase(privateKey.getAlgorithm()) || this.mechanism.getMechanismType().toUpperCase().contains("SM2") || Mechanisms.isECDSA(privateKey.getAlgorithm()) || Mechanisms.isECDSA(this.mechanism)) {
                ASN1SM2Signature asn1Value = new ASN1SM2Signature(signatureData);
                signatureBytes = asn1Value.getEncoded();
            } else {
                signatureBytes = signatureData;
            }
            this.signature = new DERBitString(signatureBytes);
            if (logger.isDebugEnabled()) {
                logger.debug("generateSignature::<<<<<<Finished: signatureData=" + SADKDebugger.dump(signatureData));
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateSignature::<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateSignature::<<<<<<Failure", e);
            }
            throw new PKIException("generateSignature Failure: " + e.getMessage(), e);
        }
    }

    private byte[] constructCertificate() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("constructCertificate::>>>>>>Running");
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(this.tbsCert);
            v.add(this.sigAlg);
            v.add(this.signature);
            DERSequence derSeq = new DERSequence(v);
            byte[] certData = null;
            try {
                certData = ASN1Parser.parseDERObj2Bytes(derSeq);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.CERT_BYTES, PKIException.CERT_BYTES_DES, ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("constructCertificate::<<<<<<Finished: certData=" + SADKDebugger.dump(certData));
            }
            return certData;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("constructCertificate::<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("constructCertificate::<<<<<<Failure", e);
            }
            throw new PKIException("constructCertificate Failure: " + e.getMessage(), e);
        }
    }
}

