/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.P10Request;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;

public final class P12FileKit {
    static final Logger logger = LoggerFactory.getLogger(P12FileKit.class);
    static volatile Session session = null;

    private P12FileKit() {
    }

    public static final String SM2GenerateKeyPair(int bitLength, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("SM2GenerateKeyPair>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            byte[] SM2Bytes;
            X509Cert cert;
            KeyPair keypair;
            Session session = P12FileKit.session();
            try {
                keypair = KeyUtil.generateKeyPair(new Mechanism("SM2"), 256, session);
            }
            catch (PKIException e) {
                throw new PKIException("SM2 KeyPair generate failure:", e);
            }
            try {
                cert = P12FileKit.SignedMyselfCert(session, keypair, "SM2");
            }
            catch (Exception e) {
                throw new PKIException("SM2 KeyPair signed myself failure", e);
            }
            try {
                SM2Bytes = P12FileKit.SM2CombineP12Data(cert, keypair.getPrivate(), password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 KeyPair failure", e);
            }
            String base64SM2Bytes = Base64.toBase64String(SM2Bytes);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2GenerateKeyPair<<<<<<Finished: base64SM2Bytes=" + base64SM2Bytes);
            }
            return base64SM2Bytes;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            }
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
    }

    public static final String SM2GenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        }
        boolean isFailed = false;
        try {
            byte[] base64p10;
            PublicKey publicKey;
            PKCS12_SM2 P10;
            if (base64EncryptedKeyData == null) {
                throw new PKIException("SM2 P10 base64EncryptedKeyData should not be null");
            }
            if (password == null) {
                throw new PKIException("SM2 P10 password should not be null");
            }
            Session session = P12FileKit.session();
            try {
                P10 = new PKCS12_SM2();
                P10.load(base64EncryptedKeyData.getBytes());
                P10.decrypt(password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 P10 loading failure ", e);
            }
            PrivateKey privateKey = P10.getPrivateKey();
            try {
                privateKey = P10.getPrivateKey();
            }
            catch (Exception e) {
                throw new PKIException("SM2 P10 Fatched PrivateKey failure", e);
            }
            try {
                publicKey = P10.getPublicCert()[0].getPublicKey();
            }
            catch (Exception e) {
                throw new PKIException("SM2 P10 Fatched PublicKey failure", e);
            }
            X500Name subject = new X500Name("CN=certRequisition,O=CFCA SM2 AGENT,C=CN");
            P10Request p10R = new P10Request(session);
            try {
                base64p10 = p10R.generatePKCS10Request(new Mechanism("sm3WithSM2Encryption"), subject, null, publicKey, privateKey, session);
            }
            catch (PKIException e) {
                throw new PKIException("SM2 P10 Generated PKCS10 failure ", e);
            }
            String base64SM2P10Text = new String(base64p10);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2GenerateP10<<<<<<Finished: base64SM2P10Text=" + base64SM2P10Text);
            }
            String string = base64SM2P10Text;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateP10<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateP10<<<<<<Failure", e);
            }
            throw new PKIException("SM2GenerateP10 Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                logger.error("SM2GenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
            }
        }
    }

    public static final String SM2CombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CombineP12>>>>>>Running");
            buffer.append("\n base64EncryptedKeyData: ");
            buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer.append("\n base64CertData: ");
            buffer.append(SADKDebugger.dump(base64CertData));
            logger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            byte[] data;
            X509Cert cert;
            PKCS12_SM2 P10;
            try {
                P10 = new PKCS12_SM2();
                P10.load(base64EncryptedKeyData.getBytes());
                P10.decrypt(password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine loading base64EncryptedKeyData failure ", e);
            }
            PrivateKey privateKey = P10.getPrivateKey();
            try {
                privateKey = P10.getPrivateKey();
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine Fatched PrivateKey failure", e);
            }
            try {
                cert = new X509Cert(base64CertData.getBytes());
            }
            catch (PKIException e) {
                throw new PKIException("SM2 Combine Fatched base64CertData failure", e);
            }
            try {
                data = P12FileKit.SM2CombineP12Data(cert, privateKey, password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine failure", e);
            }
            String base64SM2P12Text = Base64.toBase64String(data);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CombineP12<<<<<<Finished: base64SM2P12Text=" + base64SM2P12Text);
            }
            String string = base64SM2P12Text;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12<<<<<<Failure", e);
            }
            throw new PKIException("SM2CombineP12 Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12>>>>>>Running");
                buffer.append("\n base64EncryptedKeyData: ");
                buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
                buffer.append("\n base64CertData: ");
                buffer.append(SADKDebugger.dump(base64CertData));
                logger.error(buffer.toString());
            }
        }
    }

    public static String SM2CombineP12File(X509Cert x509Cert, PrivateKey priKey, String passWord, String sm2FileName) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CombineP12File>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            buffer.append("\n fileName: ");
            buffer.append(SADKDebugger.dump(sm2FileName));
            logger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            if (sm2FileName == null) {
                throw new PKIException("SM2File fileName should not be null");
            }
            byte[] encoding = P12FileKit.SM2CombineP12Data(x509Cert, priKey, passWord);
            try {
                FileHelper.write(sm2FileName, encoding);
            }
            catch (IOException e) {
                throw new PKIException("SM2File write failure with IOException", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CombineP12File<<<<<<Finished: sm2FileName=" + sm2FileName);
            }
            String string = sm2FileName;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12File<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12File<<<<<<Failure", e);
            }
            throw new PKIException("SM2CombineP12File Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12File>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(SADKDebugger.dump(x509Cert));
                buffer.append("\n fileName: ");
                buffer.append(SADKDebugger.dump(sm2FileName));
                logger.error(buffer.toString());
            }
        }
    }

    public static byte[] SM2CombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CombineP12Data>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            logger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            byte[] binaryP12Data = PKCS12_SM2.CombineSM2Data(x509Cert, priKey, password);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CombineP12Data<<<<<<Finished: binaryP12Data=" + SADKDebugger.dump(binaryP12Data));
            }
            byte[] byArray = binaryP12Data;
            return byArray;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12Data<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12Data<<<<<<Failure", e);
            }
            throw new PKIException("SM2CombineP12Data Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12Data>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(SADKDebugger.dump(x509Cert));
                logger.error(buffer.toString());
            }
        }
    }

    public static final String RSAGenerateKeyPair(int bitLength, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("RSAGenerateKeyPair>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            byte[] pfxBytes;
            X509Cert cert;
            KeyPair keypair;
            Session session = P12FileKit.session();
            if (bitLength != 1024 && bitLength != 2048) {
                throw new PKIException("PFX KeyPair Invalid bitLength=" + bitLength);
            }
            try {
                keypair = KeyUtil.generateKeyPair(new Mechanism("RSA"), bitLength, session);
            }
            catch (PKIException e) {
                throw new PKIException("PFX KeyPair generate failure:", e);
            }
            try {
                cert = P12FileKit.SignedMyselfCert(session, keypair, "RSA");
            }
            catch (Exception e) {
                throw new PKIException("PFX KeyPair signed myself failure", e);
            }
            try {
                pfxBytes = P12FileKit.RSACombineP12Data(cert, keypair.getPrivate(), password);
            }
            catch (Exception e) {
                throw new PKIException("PFX KeyPair failure", e);
            }
            String base64P12Text = Base64.toBase64String(pfxBytes);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAGenerateKeyPair<<<<<<Finished: base64P12Text=" + base64P12Text);
            }
            return base64P12Text;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            }
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
    }

    public static final String RSAGenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        }
        boolean isFailed = false;
        try {
            byte[] base64p10;
            PublicKey publicKey;
            PKCS12 P10;
            if (base64EncryptedKeyData == null) {
                throw new PKIException("PFX P10 base64EncryptedKeyData should not be null");
            }
            if (password == null) {
                throw new PKIException("PFX P10 password should not be null");
            }
            Session session = P12FileKit.session();
            try {
                P10 = new PKCS12();
                P10.load(base64EncryptedKeyData.getBytes());
                P10.decrypt(password.toCharArray());
            }
            catch (Exception e) {
                throw new PKIException("PFX P10 loading failure ", e);
            }
            PrivateKey privateKey = P10.getPrivateKey();
            try {
                privateKey = P10.getPrivateKey();
            }
            catch (Exception e) {
                throw new PKIException("PFX P10 Fatched PrivateKey failure", e);
            }
            try {
                publicKey = P10.getCerts()[0].getPublicKey();
            }
            catch (Exception e) {
                throw new PKIException("PFX P10 Fatched PublicKey failure", e);
            }
            X500Name subject = new X500Name("CN=certRequisition,O=CFCA RSA AGENT,C=CN");
            P10Request p10R = new P10Request(session);
            try {
                base64p10 = p10R.generatePKCS10Request(new Mechanism("sha256WithRSAEncryption"), subject, null, publicKey, privateKey, session);
            }
            catch (PKIException e) {
                throw new PKIException("PFX P10 Generated PKCS10 failure ", e);
            }
            String base64RSAP10Text = new String(base64p10);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAGenerateP10<<<<<<Finished: base64RSAP10Text=" + base64RSAP10Text);
            }
            String string = base64RSAP10Text;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateP10<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateP10<<<<<<Failure", e);
            }
            throw new PKIException("RSAGenerateP10 Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                logger.error("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
            }
        }
    }

    public static final String RSACombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12>>>>>>Running");
            buffer.append("\n base64EncryptedKeyData: ");
            buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer.append("\n base64CertData: ");
            buffer.append(SADKDebugger.dump(base64CertData));
            logger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            byte[] data;
            X509Cert cert;
            PKCS12 P10;
            try {
                P10 = new PKCS12();
                P10.load(base64EncryptedKeyData.getBytes());
                P10.decrypt(password.toCharArray());
            }
            catch (Exception e) {
                throw new PKIException("PFX Combine loading base64EncryptedKeyData failure ", e);
            }
            PrivateKey privateKey = P10.getPrivateKey();
            try {
                privateKey = P10.getPrivateKey();
            }
            catch (Exception e) {
                throw new PKIException("PFX Combine Fatched PrivateKey failure", e);
            }
            try {
                cert = new X509Cert(base64CertData.getBytes());
            }
            catch (PKIException e) {
                throw new PKIException("PFX Combine Decoded base64CertData failure", e);
            }
            try {
                data = P12FileKit.RSACombineP12Data(cert, privateKey, password);
            }
            catch (Exception e) {
                throw new PKIException("PFX Combine failure", e);
            }
            String base64RSAP12Text = Base64.toBase64String(data);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CombineP12<<<<<<Finished: base64RSAP12Text=" + base64RSAP12Text);
            }
            String string = base64RSAP12Text;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12<<<<<<Failure", e);
            }
            throw new PKIException("RSACombineP12 Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("RSACombineP12>>>>>>Running");
                buffer.append("\n base64EncryptedKeyData: ");
                buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
                buffer.append("\n base64CertData: ");
                buffer.append(SADKDebugger.dump(base64CertData));
                logger.error(buffer.toString());
            }
        }
    }

    public static String RSACombineP12File(X509Cert x509Cert, PrivateKey priKey, String password, String p12FileName) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12File>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            logger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            if (p12FileName == null) {
                throw new PKIException("PFXFile fileName should not be null");
            }
            byte[] encoding = P12FileKit.RSACombineP12Data(x509Cert, priKey, password);
            try {
                FileHelper.write(p12FileName, encoding);
            }
            catch (Exception e) {
                throw new PKIException("PFXFile write failure", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("RSACombineP12File<<<<<<Finished: p12FileName=" + p12FileName);
            }
            String string = p12FileName;
            return string;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12File<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12File<<<<<<Failure", e);
            }
            throw new PKIException("RSACombineP12File Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("RSACombineP12File>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(SADKDebugger.dump(x509Cert));
                logger.error(buffer.toString());
            }
        }
    }

    public static byte[] RSACombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12Data>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            logger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            byte[] binaryP12Data = PKCS12.generatePfxData(x509Cert, priKey, password);
            if (logger.isDebugEnabled()) {
                logger.debug("RSACombineP12Data<<<<<<Finished: binaryP12Data=" + SADKDebugger.dump(binaryP12Data));
            }
            byte[] byArray = binaryP12Data;
            return byArray;
        }
        catch (PKIException e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12Data<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            isFailed = true;
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12Data<<<<<<Failure", e);
            }
            throw new PKIException("RSACombineP12Data Failure", e);
        }
        finally {
            if (isFailed && logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("RSACombineP12Data>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(SADKDebugger.dump(x509Cert));
                logger.error(buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Session session() throws PKIException {
        if (session != null) return session;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (session != null) return session;
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                throw new PKIException("Open session failure: " + e.getMessage());
            }
            return session;
        }
    }

    private static final X509Cert SignedMyselfCert(Session session, KeyPair keypair, String keyType) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SignedMyselfCert::>>>>>>Running");
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n keyType: ");
            buffer.append(SADKDebugger.dump(keyType));
            logger.debug(buffer.toString());
        }
        try {
            X509CertGenerator gen = new X509CertGenerator();
            String algorithm = "RSA".equals(keyType) ? "sha256WithRSAEncryption" : "sm3WithSM2Encryption";
            String TESTDN = "CN=" + keyType + " P10 AGENT,OU=CFCA SADK P10 RSA ,O=CFCA TEST,C=CN";
            gen.setIssuer(TESTDN);
            gen.setSubject(TESTDN);
            gen.setSerialNumber(BigInteger.valueOf(1L));
            gen.setNotAfter(new Date());
            gen.setNotBefore(new Date());
            gen.setPublicKey(keypair.getPublic());
            gen.setSignatureAlg(algorithm);
            byte[] encoding = gen.generateX509Cert(keypair.getPrivate(), session);
            X509Cert x509Cert = new X509Cert(encoding);
            if (logger.isDebugEnabled()) {
                logger.debug("SignedMyselfCert<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SignedMyselfCert::<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SignedMyselfCert::<<<<<<Failure", e);
            }
            throw new PKIException("SignedMyselfCert Failure", e);
        }
    }
}

