/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.test.softLink.perf.TestFileFrame;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;

public final class TestSMxP7FileAttach
extends TestFileFrame {
    void init() throws Exception {
        String cmbcCertPath = "TestData/cmbcTest.cer";
        String sm2Path = "TestData/0001.sm2";
        String sm2Pass = "123123";
        this.priKey = KeyUtil.getPrivateKeyFromSM2("TestData/0001.sm2", "123123");
        this.cert = new X509Cert(new FileInputStream("TestData/cmbcTest.cer"));
        this.cert = CertUtil.getCertFromSM2("TestData/0001.sm2");
        this.certs = new X509Cert[]{this.cert};
    }

    String getTestName() {
        return "P7Attach: SM2-256";
    }

    public static void main(String[] args) throws Exception {
        TestFileFrame.runTest(new TestSMxP7FileAttach(), true, args);
    }

    String signedFile(String sourceFile, String id) throws UnsupportedEncodingException, PKIException {
        String signedFile = sourceFile + "." + id + ".sig";
        new Signature().p7SignFileAttach("sm3WithSM2Encryption", sourceFile, signedFile, this.priKey, this.cert, this.session);
        return signedFile;
    }

    String envelopedFile(String sourceFile, String id) throws UnsupportedEncodingException, PKIException {
        String outFilePath = null;
        outFilePath = sourceFile.indexOf(id) < 0 ? sourceFile + "." + id + ".enc" : sourceFile + ".enc";
        EnvelopeUtil.envelopeFile(sourceFile, outFilePath, "SM4/CBC/PKCS7Padding", this.certs, this.session);
        return outFilePath;
    }

    String openEnvelopedFile(String envelopedFile, String id) throws UnsupportedEncodingException, PKIException {
        String outFilePath = null;
        outFilePath = envelopedFile.indexOf(id) < 0 ? envelopedFile + "." + id + ".dec" : envelopedFile + ".dec";
        EnvelopeUtil.openEnvelopedFile(envelopedFile, outFilePath, this.priKey, this.cert, this.session);
        return outFilePath;
    }

    boolean verifiedFile(String sourceFile, String signedFile, String id) throws UnsupportedEncodingException, PKIException {
        String outFilePath = null;
        outFilePath = signedFile.indexOf(id) < 0 ? signedFile + "." + id + ".src" : signedFile + ".src";
        return new Signature().p7VerifyFileAttach(signedFile, outFilePath, this.session);
    }
}

