/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.test.softLink.perf.TestFrame;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;

public final class TestSMxP1
extends TestFrame {
    void init() throws Exception {
        String cmbcCertPath = "TestData/cmbcTest.cer";
        String sm2Path = "TestData/0001.sm2";
        String sm2Pass = "123123";
        this.priKey = KeyUtil.getPrivateKeyFromSM2("TestData/0001.sm2", "123123");
        this.cert = new X509Cert(new FileInputStream("TestData/cmbcTest.cer"));
        this.cert = CertUtil.getCertFromSM2("TestData/0001.sm2");
        this.certs = new X509Cert[]{this.cert};
    }

    String signedMessage(byte[] message) throws UnsupportedEncodingException, PKIException {
        return new String(new Signature().p1SignMessage("sm3WithSM2Encryption", message, this.priKey, this.session));
    }

    String envelopedMessage(byte[] signedData) throws UnsupportedEncodingException, PKIException {
        return new String(EnvelopeUtil.envelopeMessage(signedData, "SM4/CBC/PKCS7Padding", this.certs, this.session), "UTF8");
    }

    String openEnvelopedMessage(byte[] encryptedData) throws UnsupportedEncodingException, PKIException {
        return new String(EnvelopeUtil.openEvelopedMessage(encryptedData, this.priKey, this.cert, this.session), "UTF8");
    }

    boolean verifiedMessage(byte[] message, byte[] signature) throws UnsupportedEncodingException, PKIException {
        return new Signature().p1VerifyMessage("sm3WithSM2Encryption", message, signature, this.cert.getPublicKey(), this.session);
    }

    String getTestName() {
        return "------P1: SM2-256";
    }

    public static void main(String[] args) throws Exception {
        TestFrame.runTest(new TestSMxP1(), true, args);
    }
}

