/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.test.TestExt;
import cfca.sadk.test.softLink.perf.Constants;
import cfca.sadk.test.softLink.perf.TestFrame;
import cfca.sadk.test.softLink.perf.TestRSA1024P1;
import cfca.sadk.test.softLink.perf.TestRSA1024P7Attach;
import cfca.sadk.test.softLink.perf.TestRSA1024P7Detach;
import cfca.sadk.test.softLink.perf.TestRSA2048P1;
import cfca.sadk.test.softLink.perf.TestRSA2048P7Attach;
import cfca.sadk.test.softLink.perf.TestRSA2048P7Detach;
import cfca.sadk.test.softLink.perf.TestSMxP1;
import cfca.sadk.test.softLink.perf.TestSMxP7Attach;
import cfca.sadk.test.softLink.perf.TestSMxP7Detach;
import java.util.ArrayList;
import java.util.Formatter;

public final class TestPerfermance {
    static final int keyType_all = 7;
    static final int keyType_sm2 = 1;
    static final int keyType_rsa1024 = 2;
    static final int keyType_rsa2048 = 4;
    static final int encTypeAll = 7;
    static final int encTypeP1 = 1;
    static final int encTypeP7Attach = 2;
    static final int encTypeP7Detach = 4;

    public static void main(String[] args) throws Exception {
        boolean display = false;
        for (String arg : args) {
            if (!arg.equals("-help")) continue;
            display = true;
            break;
        }
        if (display) {
            Formatter buffer = new Formatter();
            buffer.format("command: <keyType> <sigType> <numThreads> <dataLength> <seconds> <milliseconds> {1-15} [-jni]", new Object[0]);
            buffer.format("\n", new Object[0]);
            buffer.format("\nkeyType={%-10s| %-10s| %-10s| %-10s}", "all", "sm2", "rsa1024", "rsa2048");
            buffer.format("\nencType={%-10s| %-10s| %-10s| %-10s}", "all", "p1", "p7attach", "p7detach");
            buffer.format("\nrunType={%-10s| %-10s| %-10s| %-10s}", "1=signed", "2=encrypt", "4=decrypt", "8=verify");
            buffer.format("\nrunType={%-10s+ %-10s+ %-10s+ %-10s}=15", "1=signed", "2=encrypt", "4=decrypt", "8=verify");
            TestExt.println(buffer);
        }
        int keyType = 7;
        int encType = 7;
        ArrayList<String> params = new ArrayList<String>();
        boolean report = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-jni")) {
                Constants.cryptoType = "JNISOFT_LIB";
                continue;
            }
            if (args[i].startsWith("-hard")) {
                Constants.cryptoType = "JHARD_LIB";
                continue;
            }
            if (args[i].startsWith("-card")) {
                Constants.cryptoType = "JCARD_LIB";
                continue;
            }
            if (args[i].startsWith("-report")) {
                report = true;
                continue;
            }
            params.add(args[i].toLowerCase());
        }
        args = params.toArray(new String[0]);
        if (args.length >= 2) {
            String keyTypeText = args[0];
            keyType = "sm2".equals(keyTypeText) ? 1 : ("rsa1024".equals(keyTypeText) ? 2 : ("rsa2048".equals(keyTypeText) ? 4 : ("all".equals(keyTypeText) ? 7 : 7)));
            String encTypeText = args[1];
            encType = "all".equals(encTypeText) ? 7 : ("p1".equals(encTypeText) ? 1 : ("p7attach".equals(encTypeText) ? 2 : ("p7detach".equals(encTypeText) ? 4 : 7)));
            String[] values = new String[args.length - 2];
            System.arraycopy(args, 2, values, 0, values.length);
            args = values;
        }
        if (display) {
            TestExt.println();
            TestExt.println();
            TestExt.println(String.format("TestRunning:  keyType=%-4d,  encType=%-4d, sessionType=%10s  reportType=%10s", keyType, encType, Constants.cryptoType, report));
        }
        TestPerfermance.runTests(report, keyType, encType, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runTests(boolean report, int keyType, int encType, String[] args) throws Exception {
        try {
            if ((encType & 1) == 1 && (keyType & 1) == 1) {
                TestExt.println(TestFrame.runTest(new TestSMxP1(), report, args));
            }
            if ((encType & 1) == 1 && (keyType & 2) == 2) {
                TestExt.println(TestFrame.runTest(new TestRSA1024P1(), report, args));
            }
            if ((encType & 1) == 1 && (keyType & 4) == 4) {
                TestExt.println(TestFrame.runTest(new TestRSA2048P1(), report, args));
            }
            if ((encType & 4) == 4 && (keyType & 1) == 1) {
                TestExt.println(TestFrame.runTest(new TestSMxP7Detach(), report, args));
            }
            if ((encType & 4) == 4 && (keyType & 2) == 2) {
                TestExt.println(TestFrame.runTest(new TestRSA1024P7Detach(), report, args));
            }
            if ((encType & 4) == 4 && (keyType & 4) == 4) {
                TestExt.println(TestFrame.runTest(new TestRSA2048P7Detach(), report, args));
            }
            if ((encType & 2) == 2 && (keyType & 1) == 1) {
                TestExt.println(TestFrame.runTest(new TestSMxP7Attach(), report, args));
            }
            if ((encType & 2) == 2 && (keyType & 2) == 2) {
                TestExt.println(TestFrame.runTest(new TestRSA1024P7Attach(), report, args));
            }
            if ((encType & 2) == 2 && (keyType & 4) == 4) {
                TestExt.println(TestFrame.runTest(new TestRSA2048P7Attach(), report, args));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }
}

