/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.test.softLink.perf.Constants;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicLong;

abstract class TestFileFrame {
    static final Logger logger = LoggerFactory.getLogger(TestFileFrame.class);
    static final String charsetName = "UTF8";
    AtomicLong numTotal = new AtomicLong(0L);
    long strTime = System.currentTimeMillis();
    long seconds = 15L;
    int numThread = 16;
    int dataLength = 2000;
    long runTime;
    Session session = null;
    String sourceFile = "TestData/files/test.dat";
    PrivateKey priKey = null;
    X509Cert cert = null;
    X509Cert[] certs = null;
    boolean running = true;
    boolean[] testFlags = null;
    String signedFile = null;
    String encryptedFile = null;
    String decryptedFile = null;
    boolean testResult = false;
    String cpuInfo = "windows";

    TestFileFrame() {
        try {
            JCrypto.getInstance().initialize(Constants.cryptoType, null);
            this.session = JCrypto.getInstance().openSession(Constants.cryptoType);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    abstract void init() throws Exception;

    abstract String signedFile(String var1, String var2) throws UnsupportedEncodingException, PKIException;

    abstract String envelopedFile(String var1, String var2) throws UnsupportedEncodingException, PKIException;

    abstract String openEnvelopedFile(String var1, String var2) throws UnsupportedEncodingException, PKIException;

    abstract boolean verifiedFile(String var1, String var2, String var3) throws UnsupportedEncodingException, PKIException;

    abstract String getTestName();

    final void initTestData(int option) {
        boolean sFlag = (option & 1) == 1;
        boolean eFlag = (option & 2) == 2;
        boolean dFlag = (option & 4) == 4;
        boolean vFlag = (option & 8) == 8;
        this.testFlags = new boolean[]{sFlag, eFlag, dFlag, vFlag};
        String id = Long.toString(Thread.currentThread().getId());
        try {
            this.signedFile = this.signedFile(this.sourceFile, id);
            this.encryptedFile = this.envelopedFile(this.signedFile, id);
            this.decryptedFile = this.openEnvelopedFile(this.encryptedFile, id);
            this.testResult = this.verifiedFile(this.sourceFile, this.decryptedFile, id);
            if (!this.testResult) {
                TestExt.err("testResult: " + this.testResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final boolean doneOperations(String id) {
        try {
            boolean verifyResult;
            String outFile = null;
            if (this.testFlags[0]) {
                outFile = this.signedFile(this.sourceFile, id);
            }
            if (this.testFlags[1]) {
                outFile = this.envelopedFile(outFile, id);
            }
            if (this.testFlags[2]) {
                outFile = this.openEnvelopedFile(outFile, id);
            }
            if (this.testFlags[3] && !(verifyResult = this.verifiedFile(this.sourceFile, outFile, id))) {
                TestExt.err("verifyResult: " + verifyResult);
            }
            this.numTotal.getAndIncrement();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String toString() {
        return this.toString(this.runTime, this.numTotal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String toString(long milliseconds, AtomicLong atomicLong) {
        long num = atomicLong.get();
        Formatter formatter = new Formatter();
        try {
            formatter.format("%1$tY-%1$tm-%1$te %0$tT", Calendar.getInstance());
            formatter.format(",%-16s", this.getTestName());
            formatter.format(",testBits=%s", Arrays.asList(new boolean[][]{this.testFlags}));
            formatter.format(",threads=%d", this.numThread);
            formatter.format(",dataLength=%d", this.dataLength);
            formatter.format(",tps=%-8.4f", (double)num * 1000.0 / (double)milliseconds);
            formatter.format(",seconds=%5.3f", (double)milliseconds / 1000.0);
            formatter.format(",total=%-16s", num);
            formatter.format(",testResult=%s", this.testResult);
            formatter.format(",cpu=%s", this.cpuInfo);
            String string = formatter.toString();
            return string;
        }
        finally {
            formatter.close();
        }
    }

    public static String runTest(TestFileFrame commands, boolean reportFlag, String[] args) throws Exception {
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 16;
        int dataLength = args.length > 1 ? Integer.parseInt(args[1]) : 2000;
        int seconds = args.length > 2 ? Integer.parseInt(args[2]) : 9;
        int operations = args.length > 3 ? Integer.parseInt(args[4]) : 15;
        logger.debug("TestFrame: " + commands.getTestName());
        commands.init();
        commands.initTestData(operations);
        AtomicLong numPeriod = new AtomicLong(0L);
        if (reportFlag) {
            RPTThread resportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
            resportThread.setDaemon(true);
            resportThread.start();
        }
        commands.strTime = System.currentTimeMillis();
        for (int i = 0; i < numThread; ++i) {
            OperationsThread thread = new OperationsThread(commands, numPeriod);
            thread.setDaemon(true);
            thread.start();
        }
        Thread.sleep(seconds * 1000);
        commands.running = false;
        commands.numThread = numThread;
        commands.dataLength = dataLength;
        commands.seconds = seconds;
        commands.runTime = System.currentTimeMillis() - commands.strTime;
        TestExt.println("tps:" + (double)commands.numTotal.get() * 1000.0 / (double)commands.runTime);
        return commands.toString();
    }

    static final class OperationsThread
    extends Thread {
        final TestFileFrame commands;
        final AtomicLong numPeriod;

        public OperationsThread(TestFileFrame commands, AtomicLong numPeriod) {
            this.commands = commands;
            this.numPeriod = numPeriod;
        }

        public void run() {
            String id = Long.toString(Thread.currentThread().getId());
            while (this.commands.running) {
                if (!this.commands.doneOperations(id)) continue;
                this.numPeriod.getAndIncrement();
            }
        }
    }
}

