/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.test.TestExt;
import cfca.sadk.util.EncryptUtil;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;

public final class SM4PerfTest {
    static final byte[] sm4key = "+lmHg0SOynJgW0Oz".getBytes();
    static final byte[] sm4Iv = "PzS6o6oMmEiQH3s1".getBytes();
    static long maxTime = 0L;
    static long num = 0L;

    public static void main(String[] args) throws Exception {
        long allTime;
        TestExt.err("Commands: <numThread> <seconds> <dataLength> <1|2> <delay>");
        long numThread = args.length > 0 ? (long)Integer.parseInt(args[0]) : 64L;
        long seconds = args.length > 1 ? (long)Integer.parseInt(args[1]) : 30L;
        long dataLength = args.length > 2 ? (long)Integer.parseInt(args[2]) : 4096L;
        long operations = args.length > 3 ? (long)Integer.parseInt(args[3]) : 15L;
        final long delay = (long)(args.length > 4 ? Integer.parseInt(args[4]) : 5000) * 1000000L;
        final boolean testSM4Encrypt = (1L & operations) == 1L;
        final boolean testSM4Decrypt = (2L & operations) == 2L;
        final Mechanism mechanism = new Mechanism("SM4/CBC/PKCS7Padding", new CBCParam(sm4Iv));
        final SecretKeySpec key = new SecretKeySpec(sm4key, "SM4");
        boolean jniFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (!"-jni".equals(args[i])) continue;
            jniFlag = true;
            break;
        }
        String deviceName = jniFlag ? "JNISOFT_LIB" : "JSOFT_LIB";
        JCrypto.getInstance().initialize(deviceName, null);
        final Session session = JCrypto.getInstance().openSession(deviceName);
        char[] values = new char[(int)dataLength];
        for (int i = 0; i < values.length; ++i) {
            values[i] = 97;
        }
        final byte[] message = new String(values).getBytes();
        final byte[] sm4EncryptMessage = EncryptUtil.encrypt(mechanism, key, message, session);
        byte[] desEncryptMessage = EncryptUtil.decrypt(mechanism, key, sm4EncryptMessage, session);
        TestExt.err(Arrays.equals(message, desEncryptMessage));
        Thread[] testThreads = new Thread[(int)numThread];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                long timer2;
                                long max;
                                long timer0 = System.nanoTime();
                                if (testSM4Encrypt) {
                                    EncryptUtil.encrypt(mechanism, key, message, session);
                                }
                                long timer1 = System.nanoTime();
                                if (testSM4Decrypt) {
                                    EncryptUtil.decrypt(mechanism, key, sm4EncryptMessage, session);
                                }
                                if ((max = (timer2 = System.nanoTime()) - timer0) > maxTime) {
                                    maxTime = max;
                                }
                                if (max > delay) {
                                    StringBuilder message2 = new StringBuilder();
                                    message2.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message2.append(" maxTime=").append(max);
                                    message2.append("(");
                                    message2.append(", T1SM4Enc=").append(timer1 - timer0);
                                    message2.append(", T2SM4Dec=").append(timer2 - timer1);
                                    message2.append(")").append("nanosesondes");
                                    TestExt.err(message2);
                                }
                                ++num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        long sTime = System.currentTimeMillis();
        long xTime = System.currentTimeMillis();
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        long yTime = System.currentTimeMillis();
        long allCounter = 0L;
        long avgCounter = 0L;
        long avgTime = 0L;
        do {
            Thread.sleep(5000L);
            avgCounter = num;
            yTime = System.currentTimeMillis();
            avgTime = yTime - xTime;
            xTime = System.currentTimeMillis();
            num = 0L;
            allTime = System.currentTimeMillis() - sTime;
            long avg = 1000L * avgCounter / avgTime;
            long all = 1000L * (allCounter += avgCounter) / allTime;
            StringBuilder text = new StringBuilder();
            text.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            text.append(" commands=").append(Arrays.asList(args));
            text.append(", numThread=").append(numThread);
            text.append(", seconds=").append(seconds);
            text.append(", dataLength=").append(dataLength);
            text.append(", operations=").append(operations);
            text.append(", maxTime=").append(maxTime);
            text.append(", AVG-TPS=").append(avg);
            text.append("(").append(avgCounter);
            text.append(",").append(avgTime);
            text.append(")");
            text.append(", ALL-TPS=").append(all);
            text.append("(").append(allCounter);
            text.append(",").append(allTime);
            text.append(")");
            TestExt.err(text);
        } while (allTime <= seconds * 1000L);
        TestExt.err("Finished");
    }

    static final BigInteger testRSA(byte[] data, BigInteger n, BigInteger e, BigInteger d) {
        BigInteger x = new BigInteger(1, data);
        BigInteger y = x.modPow(e, n);
        BigInteger z = y.modPow(d, n);
        return z;
    }
}

