/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.util.HashUtil;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SM3PerfTestJava {
    public static void main(String[] args) throws Exception {
        int i;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay>");
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 600000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 48;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 2;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        final boolean testSM3 = (1 & operations) == 1;
        final boolean testSM3Ext = (2 & operations) == 2;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        CardLib session = new CardLib(null);
        KeyPair keypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1)), 0);
        final SM2CardPublicKey PublicKey2 = (SM2CardPublicKey)keypair.getPublic();
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                long timer2;
                                long max;
                                long timer0 = System.currentTimeMillis();
                                if (testSM3) {
                                    HashUtil.SM2HashMessageByBCWithoutZValue(data);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testSM3Ext) {
                                    HashUtil.SM2HashMessageByBCWithZValue(SM2Params.getDefaultuserid(), data, PublicKey2.getPubXByInt(), PublicKey2.getPubYByInt());
                                }
                                if ((max = (timer2 = System.currentTimeMillis()) - timer0) > reportThread.maxTime) {
                                    reportThread.maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(", SM3=").append(timer1 - timer0);
                                    message.append(", SM3ZExt=").append(timer2 - timer1);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        reportThread.run();
    }
}

