/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.system.FileHelper;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class SM2PerfTestCardP7AttachExternal {
    public static void main(String[] args) throws Exception {
        int i;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay>");
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 600000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 48;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        final boolean testSign = (1 & operations) == 1;
        final boolean testEncrypt = (2 & operations) == 2;
        final boolean testDecrypt = (4 & operations) == 4;
        final boolean testVerify = (8 & operations) == 8;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        final Session cardLib = JCrypto.getInstance().openSession("JCARD_LIB");
        final Session javaLib = BCSoftLib.INSTANCE();
        KeyPair keypair = javaLib.generateKeyPair(new Mechanism("SM2"), 256);
        final X509Cert cert = TestExt.buildX509CertGenerator(keypair.getPrivate(), keypair.getPublic(), cardLib);
        final PrivateKey signPrivateKey = keypair.getPrivate();
        String signAlg = "sm3WithSM2Encryption";
        final Signature signatureUtil = new Signature();
        if ((operations & 0x1F) == 31) {
            try {
                byte[] base64P7SignedData = null;
                base64P7SignedData = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, cert, javaLib);
                boolean verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedData, javaLib);
                TestExt.err("VerifyResult: " + verifyResult);
                verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedData, cardLib);
                TestExt.err("VerifyResult: " + verifyResult);
                String sourceFilePath = "/tmp/data.dat";
                String outSignedFilePath = "/tmp/sign.p7b";
                String outSourceFilePath = "/tmp/sign.verifyResult";
                FileHelper.write("/tmp/data.dat", data);
                signatureUtil.p7SignFileAttach("sm3WithSM2Encryption", "/tmp/data.dat", "/tmp/sign.p7b", signPrivateKey, cert, javaLib);
                verifyResult = signatureUtil.p7VerifyFileAttach("/tmp/sign.p7b", "/tmp/sign.verifyResult", javaLib);
                TestExt.err("verifyResult: " + verifyResult);
                verifyResult = signatureUtil.p7VerifyFileAttach("/tmp/sign.p7b", "/tmp/sign.verifyResult", cardLib);
                TestExt.err("verifyResult: " + verifyResult);
                verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedData, cardLib);
                TestExt.err("verifyResult: " + verifyResult);
                TestExt.err("verifyResult: Successfully");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        final PrivateKey encxPrivateKey = keypair.getPrivate();
        String symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
        final X509Cert[] receivers = new X509Cert[]{cert};
        if ((operations & 0x1F) == 31) {
            byte[] base64EnvelopeMessage = null;
            byte[] decryptData = null;
            base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, cardLib);
            decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage, encxPrivateKey, cert, javaLib);
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
            base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, cardLib);
            decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage, encxPrivateKey, cert, javaLib);
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
            String sourceFilePath = "/tmp/data.dat";
            String outEncryptFilePath = "/tmp/data.env";
            String outDecryptFilePath = "/tmp/data.dev";
            FileHelper.write("/tmp/data.dat", data);
            EnvelopeUtil.envelopeFile("/tmp/data.dat", "/tmp/data.env", "SM4/CBC/PKCS7Padding", receivers, cardLib);
            EnvelopeUtil.openEnvelopedFile("/tmp/data.env", "/tmp/data.dev", encxPrivateKey, cert, javaLib);
            decryptData = FileHelper.read("/tmp/data.dev");
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
        }
        final byte[] base64P7SignedData = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, cert, javaLib);
        final byte[] base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, cardLib);
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    boolean verifyResult = false;
                    byte[] base64P7SignedBytes = base64P7SignedData;
                    byte[] base64EnvelopeBytes = base64EnvelopeMessage;
                    byte[] decryptData = null;
                    while (true) {
                        try {
                            while (true) {
                                long timer4;
                                long max;
                                long timer0 = System.currentTimeMillis();
                                if (testSign) {
                                    base64P7SignedBytes = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, cert, javaLib);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testEncrypt) {
                                    base64EnvelopeBytes = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, cardLib);
                                }
                                long timer2 = System.currentTimeMillis();
                                if (testDecrypt && !Arrays.equals(decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeBytes, encxPrivateKey, cert, javaLib), data)) {
                                    ++reportThread.failure;
                                }
                                long timer3 = System.currentTimeMillis();
                                if (testVerify && !(verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedBytes, cardLib))) {
                                    ++reportThread.failure;
                                }
                                if ((max = (timer4 = System.currentTimeMillis()) - timer0) > reportThread.maxTime) {
                                    reportThread.maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(", T1Sign=").append(timer1 - timer0);
                                    message.append(", T2Encrypt=").append(timer2 - timer1);
                                    message.append(", T3Decrypt=").append(timer3 - timer2);
                                    message.append(", T4Verify=").append(timer4 - timer3);
                                    message.append(", TxFailure=").append(reportThread.failure);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        reportThread.run();
    }
}

