/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.util.Base64;
import cfca.sadk.util.HashUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class SM2PerfTestCardP1 {
    public static void main(String[] args) throws Exception {
        int i;
        boolean verifyResult;
        byte[] signature;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay>");
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 600000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 48;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        final boolean testSign = (1 & operations) == 1;
        final boolean testEncrypt = (2 & operations) == 2;
        final boolean testDecrypt = (4 & operations) == 4;
        final boolean testVerify = (8 & operations) == 8;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        final byte[] base64 = Base64.encode(data);
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        final Session session = JCrypto.getInstance().openSession("JCARD_LIB");
        KeyPair signKeypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1)), 0);
        final PrivateKey signPrivateKey = signKeypair.getPrivate();
        SM2PublicKey signPublicKey = new SM2PublicKey(signKeypair.getPublic().getEncoded());
        final X509Cert signCert = TestExt.buildX509CertGenerator(signKeypair.getPrivate(), signKeypair.getPublic(), session);
        final byte[] encoding = signCert.getEncoded();
        final Mechanism smechanism = new Mechanism("sm3WithSM2Encryption");
        byte[] hashValue = HashUtil.SM2HashMessageByBCWithZValue(SM2Params.getDefaultuserid(), data, signPublicKey.getPubX_Int(), signPublicKey.getPubY_Int());
        if ((operations & 0x1F) == 31) {
            try {
                signature = session.sign(smechanism, signPrivateKey, data);
                TestExt.err("VerifyResult1: " + signature.length);
                verifyResult = session.verify(smechanism, (PublicKey)signPublicKey, data, signature);
                TestExt.err("VerifyResult1: " + verifyResult);
                verifyResult = session.verifyByHash(smechanism, signPublicKey, hashValue, signature);
                TestExt.err("VerifyResult1: " + verifyResult);
                verifyResult = BCSoftLib.INSTANCE().verify(smechanism, (PublicKey)signPublicKey, data, signature);
                TestExt.err("VerifyResult1: " + verifyResult);
                signature = session.signByHash(smechanism, signPrivateKey, hashValue);
                TestExt.err("VerifyResult2: " + signature.length);
                verifyResult = session.verifyByHash(smechanism, signPublicKey, hashValue, signature);
                TestExt.err("VerifyResult2: " + verifyResult);
                verifyResult = session.verify(smechanism, (PublicKey)signPublicKey, data, signature);
                TestExt.err("VerifyResult2: " + verifyResult);
                verifyResult = BCSoftLib.INSTANCE().verifyByHash(smechanism, signPublicKey, hashValue, signature);
                TestExt.err("VerifyResult2: " + verifyResult);
                verifyResult = BCSoftLib.INSTANCE().verify(smechanism, (PublicKey)signPublicKey, data, signature);
                TestExt.err("VerifyResult2: " + verifyResult);
                Mechanism emechanism = new Mechanism("SM2");
                byte[] enmessage = BCSoftLib.INSTANCE().encrypt(emechanism, signPublicKey, data);
                byte[] demessage = session.decrypt(emechanism, signPrivateKey, enmessage);
                TestExt.err("HardEncryptResult: " + Arrays.equals(data, demessage));
                enmessage = session.encrypt(emechanism, signPublicKey, data);
                demessage = session.decrypt(emechanism, signPrivateKey, enmessage);
                TestExt.err("HardEncryptResult: " + Arrays.equals(data, demessage));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        signature = session.signByHash(smechanism, signPrivateKey, hashValue);
        verifyResult = session.verifyByHash(smechanism, signPublicKey, hashValue, signature);
        TestExt.err("VerifyResult: " + verifyResult);
        final Signature signatureUtil = new Signature();
        final byte[] base64P1SignedData = signatureUtil.p1SignMessage(smechanism.getMechanismType(), data, signPrivateKey, session);
        verifyResult = signatureUtil.p1VerifyMessage(smechanism.getMechanismType(), data, base64P1SignedData, signPublicKey, session);
        TestExt.err("VerifyResult: " + verifyResult);
        verifyResult = signatureUtil.p1VerifyMessage(smechanism.getMechanismType(), data, base64P1SignedData, signPublicKey, BCSoftLib.INSTANCE());
        TestExt.err("VerifyResult: " + verifyResult);
        KeyPair encxKeypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1, 1)), 0);
        final PrivateKey encxPrivateKey = encxKeypair.getPrivate();
        final PublicKey encxPublicKey = encxKeypair.getPublic();
        TestExt.err(signPublicKey);
        TestExt.err(encxPublicKey);
        final Mechanism emechanism = new Mechanism("SM2");
        byte[] enmessage = session.encrypt(emechanism, encxPublicKey, data);
        byte[] demessage = session.decrypt(emechanism, encxPrivateKey, enmessage);
        TestExt.err("HardEncryptResult: " + Arrays.equals(data, demessage));
        final byte[] softEncryptData = BCSoftLib.INSTANCE().encrypt(emechanism, encxPublicKey, data);
        byte[] hardDecryptData = session.decrypt(emechanism, encxPrivateKey, softEncryptData);
        TestExt.err("SoftEncryptResult: " + Arrays.equals(data, hardDecryptData));
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    byte[] emessage = softEncryptData;
                    byte[] base64P1SignedBytes = base64P1SignedData;
                    byte[] dmessage = null;
                    boolean verifyResult = false;
                    while (true) {
                        try {
                            while (true) {
                                long timer4;
                                long max;
                                long timer0 = System.currentTimeMillis();
                                if (testSign) {
                                    Base64.decode(base64);
                                    signatureUtil.p1SignMessage(smechanism.getMechanismType(), data, signPrivateKey, session);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testEncrypt) {
                                    emessage = session.encrypt(emechanism, encxPublicKey, data);
                                }
                                long timer2 = System.currentTimeMillis();
                                if (testDecrypt && !Arrays.equals(dmessage = session.decrypt(emechanism, encxPrivateKey, emessage), data)) {
                                    ++reportThread.failure;
                                }
                                long timer3 = System.currentTimeMillis();
                                if (testVerify) {
                                    new X509Cert(encoding);
                                    verifyResult = signatureUtil.p1VerifyMessage(smechanism.getMechanismType(), data, base64P1SignedBytes, signCert.getPublicKey(), session);
                                    if (!verifyResult) {
                                        ++reportThread.failure;
                                    }
                                }
                                if ((max = (timer4 = System.currentTimeMillis()) - timer0) > reportThread.maxTime) {
                                    reportThread.maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(", T1Sign=").append(timer1 - timer0);
                                    message.append(", T2Encrypt=").append(timer2 - timer1);
                                    message.append(", T3Decrypt=").append(timer3 - timer2);
                                    message.append(", T4Verify=").append(timer4 - timer3);
                                    message.append(", TxFailure=").append(reportThread.failure);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        reportThread.run();
    }
}

