/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.util.HashUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class SM2PerfTestCard1 {
    public static void main(String[] args) throws Exception {
        int i;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay>");
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 6000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 4096;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        final boolean testSign = (1 & operations) == 1;
        final boolean testEncrypt = (2 & operations) == 2;
        final boolean testDecrypt = (4 & operations) == 4;
        final boolean testVerify = (8 & operations) == 8;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        byte[] hashValue = HashUtil.SM2HashMessageByBCWithoutZValue(data);
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        final Session session = JCrypto.getInstance().openSession("JCARD_LIB");
        KeyPair keypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1)), 0);
        final PrivateKey privateKey = keypair.getPrivate();
        final PublicKey publicKey = keypair.getPublic();
        final Mechanism smechanism = new Mechanism("sm3WithSM2Encryption");
        final Mechanism emechanism = new Mechanism("SM2");
        byte[] signature = session.signByHash(smechanism, privateKey, hashValue);
        boolean verifyResult = session.verifyByHash(smechanism, publicKey, hashValue, signature);
        TestExt.err("VerifyResult: " + verifyResult);
        final byte[] enmessage = session.encrypt(emechanism, publicKey, data);
        byte[] demessage = session.decrypt(emechanism, privateKey, enmessage);
        TestExt.err("DecryptResult: " + Arrays.equals(data, demessage));
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    byte[] emessage = new byte[data.length + 96];
                    System.arraycopy(enmessage, 0, emessage, 0, emessage.length);
                    byte[] signature = null;
                    byte[] dmessage = null;
                    boolean verifyResult = false;
                    while (true) {
                        try {
                            while (true) {
                                long timer4;
                                long max;
                                byte[] hash;
                                long timer0 = System.currentTimeMillis();
                                if (testSign) {
                                    byte[] hash2 = HashUtil.SM2HashMessageByBCWithoutZValue(data);
                                    signature = session.signByHash(smechanism, privateKey, hash2);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testEncrypt) {
                                    emessage = session.encrypt(emechanism, publicKey, data);
                                }
                                long timer2 = System.currentTimeMillis();
                                if (testDecrypt && !Arrays.equals(dmessage = session.decrypt(emechanism, privateKey, emessage), data)) {
                                    ++reportThread.failure;
                                }
                                long timer3 = System.currentTimeMillis();
                                if (testVerify && !(verifyResult = session.verifyByHash(smechanism, publicKey, hash = HashUtil.SM2HashMessageByBCWithoutZValue(data), signature))) {
                                    ++reportThread.failure;
                                }
                                if ((max = (timer4 = System.currentTimeMillis()) - timer0) > reportThread.maxTime) {
                                    reportThread.maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(", T1Sign=").append(timer1 - timer0);
                                    message.append(", T2Encrypt=").append(timer2 - timer1);
                                    message.append(", T3Decrypt=").append(timer3 - timer2);
                                    message.append(", T4Verify=").append(timer4 - timer3);
                                    message.append(", TxFailure=").append(reportThread.failure);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        reportThread.run();
    }
}

