/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.CPUThread;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class RPTThread
extends Thread {
    long maxTime = 0L;
    long num = 0L;
    int failure = 0;
    final int numThread;
    final String[] args;
    final long seconds;
    final int dataLength;
    final int operations;
    final CPUThread CPUThread;

    public RPTThread(int numThread, String[] args, long seconds, int dataLength, int operations) {
        this.numThread = numThread;
        this.args = args;
        this.seconds = seconds;
        this.dataLength = dataLength;
        this.operations = operations;
        this.CPUThread = new CPUThread();
        this.CPUThread.setDaemon(true);
        this.CPUThread.start();
    }

    public void run() {
        long sTime = System.currentTimeMillis();
        long xTime = System.currentTimeMillis();
        long yTime = System.currentTimeMillis();
        long allCounter = 0L;
        long avgCounter = 0L;
        long avgTime = 0L;
        Logger logger = LoggerFactory.getLogger(RPTThread.class);
        TestExt.err("env>>>>>>" + System.getenv());
        while (true) {
            try {
                long allTime;
                do {
                    Thread.sleep(5000L);
                    avgCounter = this.num;
                    yTime = System.currentTimeMillis();
                    avgTime = yTime - xTime;
                    xTime = System.currentTimeMillis();
                    this.num = 0L;
                    allTime = System.currentTimeMillis() - sTime;
                    long avg = 1000L * avgCounter / avgTime;
                    long all = 1000L * (allCounter += avgCounter) / allTime;
                    StringBuffer text = new StringBuffer();
                    text.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    text.append(" commands=").append(Arrays.asList(this.args));
                    text.append(", numThread=").append(this.numThread);
                    text.append(", seconds=").append(this.seconds);
                    text.append(", dataLength=").append(this.dataLength);
                    text.append(", operations=").append(this.operations);
                    text.append(", maxTime=").append(this.maxTime);
                    text.append(", AVG-TPS=").append(avg);
                    text.append("(").append(avgCounter);
                    text.append(",").append(avgTime);
                    text.append(")");
                    text.append(", ALL-TPS=").append(all);
                    text.append("(").append(allCounter);
                    text.append(",").append(allTime);
                    text.append(") Failure=").append(this.failure);
                    text.append(" ").append(this.CPUThread.cpuInfo);
                    String message = text.toString();
                    TestExt.err(message);
                    logger.info(message);
                } while (allTime <= this.seconds * 1000L);
                TestExt.err("Finished");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

