/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Arrays;

public final class CPUCoreSM2PerfTestCardP7AttachExternal {
    public static void main(String[] args) throws Exception {
        int i;
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 600000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 48;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        final boolean testSign = (1 & operations) == 1;
        final boolean testEncrypt = (2 & operations) == 2;
        final boolean testDecrypt = (4 & operations) == 4;
        final boolean testVerify = (8 & operations) == 8;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        final Session cardLib = JCrypto.getInstance().openSession("JCARD_LIB");
        final Session javaLib = BCSoftLib.INSTANCE();
        KeyPair keypair = javaLib.generateKeyPair(new Mechanism("SM2"), 256);
        final X509Cert cert = TestExt.buildX509CertGenerator(keypair.getPrivate(), keypair.getPublic(), cardLib);
        final PrivateKey signPrivateKey = keypair.getPrivate();
        String signAlg = "sm3WithSM2Encryption";
        final Signature signatureUtil = new Signature();
        final PrivateKey encxPrivateKey = keypair.getPrivate();
        String symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
        final X509Cert[] receivers = new X509Cert[]{cert};
        final byte[] base64P7SignedData = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, cert, javaLib);
        final byte[] base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, cardLib);
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    boolean verifyResult = false;
                    byte[] base64P7SignedBytes = base64P7SignedData;
                    byte[] base64EnvelopeBytes = base64EnvelopeMessage;
                    byte[] decryptData = null;
                    while (true) {
                        try {
                            while (true) {
                                if (testSign) {
                                    base64P7SignedBytes = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, cert, javaLib);
                                }
                                if (testEncrypt) {
                                    base64EnvelopeBytes = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, cardLib);
                                }
                                if (testDecrypt && !Arrays.equals(decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeBytes, encxPrivateKey, cert, javaLib), data)) {
                                    ++reportThread.failure;
                                }
                                if (testVerify && !(verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedBytes, cardLib))) {
                                    ++reportThread.failure;
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(seconds);
        TestExt.println(reportThread.num);
    }
}

