/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.JoranConfigurator;
import cfca.ch.qos.logback.core.Context;
import cfca.org.slf4j.ILoggerFactory;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.test.TestExt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class CPUCoreMainFrame {
    static final Logger logger = LoggerFactory.getLogger(CPUCoreMainFrame.class);

    public static void main(String[] args) throws Exception {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        LoggerContext lc = (LoggerContext)loggerFactory;
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure("config/logback-cfca-sadk.xml");
        CPUThread xx = new CPUThread();
        xx.setDaemon(true);
        xx.start();
        BufferedReader commandsReader = null;
        commandsReader = new BufferedReader(new FileReader("TestData/commands.txt"));
        logger.info(CPUCoreMainFrame.class.getName());
        String commandLine = null;
        while ((commandLine = commandsReader.readLine()) != null) {
            if (!commandLine.startsWith("command")) continue;
            commandLine = commandLine.substring(1 + commandLine.indexOf(61));
            CPUCoreMainFrame.exec(commandLine);
            Thread.sleep(5000L);
        }
        if (commandsReader != null) {
            commandsReader.close();
        }
    }

    static final void exec(String commandName) throws Exception {
        logger.info("command:=" + commandName);
        String[] commands = commandName.split(":");
        int numProcess = Integer.parseInt(commands[0]);
        String[] args = commands[1].split(" ");
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String[] command = new String[3 + args.length];
        command[0] = java;
        command[1] = "-classpath";
        command[2] = classpath;
        System.arraycopy(args, 0, command, 3, args.length);
        TestResult testResult = new TestResult();
        Process[] ps = new Process[numProcess];
        boolean bind = true;
        int core = 8;
        for (int i = 0; i < ps.length; ++i) {
            if (bind) {
                String[] cmd = new String[3 + command.length];
                System.arraycopy(command, 0, cmd, 3, command.length);
                cmd[0] = "taskset";
                cmd[1] = "-c";
                cmd[2] = "" + (1 + i % (core - 1));
                ps[i] = Runtime.getRuntime().exec(cmd);
            } else {
                ps[i] = Runtime.getRuntime().exec(command);
            }
            CPUCoreMainFrame.monitor(ps[i], testResult);
        }
        int codeResult = 0;
        for (int i = 0; i < ps.length; ++i) {
            try {
                codeResult = ps[i].waitFor();
                logger.info(commandName + ": testResultFinished[" + i + "]= " + codeResult);
                if (codeResult == 0) continue;
                ps[i].destroy();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info(commandName + ": testResultPerfermanceTPS= " + testResult.tps);
    }

    static final void monitor(final Process p, final TestResult testResult) {
        try {
            Thread eThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        String readLine = null;
                        while ((readLine = br.readLine()) != null) {
                            TestExt.println("Hint: " + readLine);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            eThread.setDaemon(true);
            eThread.start();
            Thread iThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String readLine = null;
                        while ((readLine = br.readLine()) != null) {
                            if (!readLine.startsWith("tps:")) continue;
                            testResult.tps += Double.parseDouble(readLine.substring(1 + readLine.indexOf(58)));
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            iThread.setDaemon(true);
            iThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static final class CPUThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block18: {
                Process cmd;
                BufferedReader br;
                block16: {
                    block15: {
                        boolean linuxFlag;
                        br = null;
                        cmd = null;
                        boolean bl = linuxFlag = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
                        if (linuxFlag) {
                            cmd = Runtime.getRuntime().exec("top -b -S -d 1");
                            br = new BufferedReader(new InputStreamReader(cmd.getInputStream()));
                            String readLine = null;
                            String cpuInfo = null;
                            while ((readLine = br.readLine()) != null) {
                                if (!readLine.startsWith("Cpu(s):")) continue;
                                cpuInfo = readLine.substring(0, readLine.indexOf(44));
                                logger.info(cpuInfo);
                                TestExt.println(cpuInfo);
                            }
                            break block15;
                        }
                        logger.info("window");
                        TestExt.println("window cpuInfo");
                    }
                    Object var7_7 = null;
                    if (br == null) break block16;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (cmd != null) {
                    cmd.destroy();
                }
                break block18;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var7_8 = null;
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        if (cmd != null) {
                            cmd.destroy();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    if (cmd != null) {
                        cmd.destroy();
                    }
                    throw throwable;
                }
            }
        }
    }

    static final class TestResult {
        double tps;

        TestResult() {
        }
    }
}

