/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.Envelope;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.SecureRandom;

public final class TestFastRandom {
    public static void main(String[] args) throws Exception {
        int i;
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        final Session session = params.session;
        final byte[] data = params.data;
        final SecureRandom randomG = new SecureRandom();
        KeyPair signKeypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1)), 0);
        KeyPair encxKeypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1, 1)), 0);
        String symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
        X509Cert recipient = TestExt.buildX509CertGenerator(signKeypair.getPrivate(), encxKeypair.getPublic(), session);
        final X509Cert[] receivers = new X509Cert[]{recipient};
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    SecureRandom random = new SecureRandom();
                    while (true) {
                        try {
                            while (true) {
                                if (params.testSign) {
                                    randomG.nextBytes(data);
                                }
                                if (params.testEncrypt) {
                                    random.nextBytes(data);
                                }
                                if (params.testDecrypt) {
                                    SecureRandoms.getInstance().newSecureRandom().nextBytes(data);
                                }
                                if (params.testVerify) {
                                    Envelope.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, session);
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

