/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import javax.crypto.spec.SecretKeySpec;

public final class TestCardSM4 {
    public static void main(String[] args) throws Exception {
        int i;
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        final byte[] data = params.data;
        final Session session = params.session;
        byte[] iv = SecureRandoms.getInstance().genBytes(16);
        byte[] keyBytes = SecureRandoms.getInstance().genBytes(16);
        final Mechanism mechanism = new Mechanism("SM4/CBC/PKCS7Padding", new CBCParam(iv));
        final SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        final byte[] base64EncryptData = session.encrypt(mechanism, key, data);
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                if (params.testSign) {
                                    session.encrypt(mechanism, key, data);
                                }
                                if (params.testEncrypt) {
                                    session.decrypt(mechanism, key, base64EncryptData);
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

