/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public final class TestCardRSAP7Attach {
    public static void main(String[] args) throws Exception {
        int i;
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        final byte[] data = params.data;
        final Session session = params.session;
        KeyPair keypair = session.generateKeyPair(new Mechanism("RSA"), 2048);
        final PrivateKey privateKey = keypair.getPrivate();
        PublicKey publicKey = keypair.getPublic();
        String signAlg = "sha1WithRSAEncryption";
        final Signature signatureUtil = new Signature();
        String symmetricAlgorithm = "DESede/CBC/PKCS7Padding";
        final X509Cert recipient = TestExt.buildX509CertGenerator(privateKey, publicKey, session);
        final X509Cert[] receivers = new X509Cert[]{recipient};
        final byte[] base64SignedData = signatureUtil.p7SignMessageAttach("sha1WithRSAEncryption", data, privateKey, recipient, session);
        final byte[] base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "DESede/CBC/PKCS7Padding", receivers, session);
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    boolean verifyResult = false;
                    byte[] base64SignedBytes = base64SignedData;
                    byte[] base64EnvelopeBytes = base64EnvelopeMessage;
                    byte[] decryptData = null;
                    while (true) {
                        try {
                            while (true) {
                                if (params.testSign) {
                                    base64SignedBytes = signatureUtil.p7SignMessageAttach("sha1WithRSAEncryption", data, privateKey, recipient, session);
                                }
                                if (params.testEncrypt) {
                                    base64EnvelopeBytes = EnvelopeUtil.envelopeMessage(data, "DESede/CBC/PKCS7Padding", receivers, session);
                                }
                                if (params.testDecrypt && !Arrays.equals(decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeBytes, privateKey, recipient, session), data)) {
                                    ++report.failure;
                                }
                                if (params.testVerify && !(verifyResult = signatureUtil.p7VerifyMessageAttach(base64SignedBytes, session))) {
                                    ++report.failure;
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

