/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.Conf;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import cfca.sadk.util.Base64;
import cryptokit.jni.JNIP11;
import java.util.Arrays;

public final class TestCardJNISM2NoneInit {
    static final int CKM_SM2_WITH_Z = 1;
    static final int CKM_SM2_SIGN_VERIFY = 65538;
    static final int CKM_SM2_EXTERNAL_VERIFY = 65548;
    static final int CKM_SM2_EXTERNAL_ENCRYPT = 65549;

    public static void main(String[] args) throws Exception {
        int i;
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        final byte[] data = params.data;
        Conf conf = new Conf("config/card-cfca.ini");
        final JNIP11 jni = new JNIP11();
        jni.loadLib(conf.p11LibPath);
        jni.init();
        byte[] password = conf.p11Password.getBytes("UTF8");
        int[] tokens = new int[16];
        int tokenNum = jni.getTokenList(tokens);
        for (int i2 = 0; i2 < tokenNum; ++i2) {
            jni.getTokenInfo(tokens[i2]);
        }
        final int token = conf.cardToken;
        long sessionHandleG = jni.openSession(token);
        jni.login(sessionHandleG, (int)jni.CKU_USER, password, password.length);
        jni.getCKIDList(sessionHandleG);
        byte[] keypairID = "1".getBytes("UTF8");
        final long encxPBKHandle = jni.getKeyHandle(sessionHandleG, keypairID, 1, true, true);
        final long encxPVKHandle = jni.getKeyHandle(sessionHandleG, keypairID, 1, false, true);
        final long signPBKHandle = jni.getKeyHandle(sessionHandleG, keypairID, 2, true, true);
        final long signPVKHandle = jni.getKeyHandle(sessionHandleG, keypairID, 2, false, true);
        final byte[] hashValue = Base64.decode("jfAhbn6vtPgRR3qdjJXKOi3PLSuDIBgoRp6Ij5p7Al0=");
        final byte[] signValue = new byte[64];
        jni.signInit(sessionHandleG, signPVKHandle, 65538, 1);
        jni.signHash(sessionHandleG, hashValue, signValue);
        jni.verifyInit(sessionHandleG, signPBKHandle, 65538, 1);
        jni.verify(sessionHandleG, hashValue, signValue);
        final byte[] encryptData = new byte[96 + data.length];
        jni.encryptInit(sessionHandleG, encxPBKHandle, 0);
        jni.encryptMsg(sessionHandleG, data, encryptData);
        final byte[] decryptData = new byte[data.length];
        jni.decryptInit(sessionHandleG, encxPVKHandle);
        jni.decryptMsg(sessionHandleG, encryptData, decryptData);
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    long sessionHandle;
                    try {
                        sessionHandle = jni.openSession(token);
                        if (params.testSign) {
                            jni.signInit(sessionHandle, signPVKHandle, 65538, 1);
                        }
                        if (params.testEncrypt) {
                            jni.encryptInit(sessionHandle, encxPBKHandle, 0);
                        }
                        if (params.testDecrypt) {
                            jni.decryptInit(sessionHandle, encxPVKHandle);
                        }
                        if (params.testVerify) {
                            jni.verifyInit(sessionHandle, signPBKHandle, 65538, 1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    while (true) {
                        try {
                            while (true) {
                                int returnValue;
                                if (params.testSign) {
                                    jni.signHash(sessionHandle, hashValue, signValue);
                                }
                                if (params.testEncrypt) {
                                    jni.encryptMsg(sessionHandle, data, encryptData);
                                }
                                if (params.testDecrypt) {
                                    jni.decryptMsg(sessionHandle, encryptData, decryptData);
                                    if (!Arrays.equals(decryptData, data)) {
                                        ++report.failure;
                                    }
                                }
                                if (params.testVerify && (returnValue = jni.verify(sessionHandle, hashValue, signValue)) != 0) {
                                    ++report.failure;
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

