/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;

final class TestCardConf {
    final String sm2P11LibPath;
    final String sm2P11Password;
    final int sm2CardType;
    final int sm2CardToken;
    final int sm2CardSessionNumb;
    final int sm2CardSessionTimeout;
    final String sm2cardImplClass;
    final String rsacardImplClass;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TestCardConf(String cardIniPath) throws PKIException {
        File path = null;
        if (cardIniPath == null) {
            File config = new File("config/card-cfca.ini");
            if (config.exists() && config.isFile()) {
                path = config;
            } else {
                config = new File("/etc/card-cfca.ini");
                if (!config.exists() || !config.isFile()) throw new PKIException("CardConf<<<<<<Failure: invalid cardIniPath");
                path = config;
            }
        } else {
            path = new File(cardIniPath);
            if (!path.exists() || path.isDirectory()) {
                throw new PKIException("CardConf<<<<<<Failure: invalid cardIniPath=" + cardIniPath);
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            throw new PKIException("CardConf<<<<<<Load failure: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PKIException("CardConf<<<<<<Load failure: " + e.getMessage(), e);
        }
        try {
            this.sm2P11LibPath = properties.getProperty("cfca.sm2card.p11LibPath", "/lib64/libpkcs11_for_c200.so");
            this.sm2P11Password = properties.getProperty("cfca.sm2card.p11Password", "abcd1234");
        }
        catch (Exception e) {
            throw new PKIException("CardConf<<<<<<Load p11LibPath/p11Password failure:  " + e.getMessage(), e);
        }
        this.sm2CardType = this.integerFrom(properties, "cfca.sm2card.cardType", 0);
        this.sm2CardToken = this.integerFrom(properties, "cfca.sm2card.cardToken", 1);
        this.sm2CardSessionNumb = this.integerFrom(properties, "cfca.sm2card.cardSessionNumb", 60);
        this.sm2CardSessionTimeout = this.integerFrom(properties, " cfca.sm2card.cardSessionTimeout", 60);
        this.sm2cardImplClass = properties.getProperty("cfca.sm2card.ImplClass", "cfca.sadk.lib.crypto.card.SM2Card");
        this.rsacardImplClass = properties.getProperty("cfca.rsacard.ImplClass", "cfca.sadk.lib.crypto.card.cavium.CaviumRSACard");
    }

    private final int integerFrom(Properties properties, String key, int defValue) throws PKIException {
        int value = defValue;
        try {
            value = Integer.decode(properties.getProperty(key, Integer.toString(defValue)));
        }
        catch (Exception e) {
            throw new PKIException("CardConf<<<<<<Load  " + key + " failure: " + e.getMessage(), e);
        }
        return value;
    }

    final SM2CardInfo getSM2CardInfo() {
        return new SM2CardInfo(this.sm2P11LibPath, this.sm2P11Password, this.sm2CardType, this.sm2CardToken, this.sm2CardSessionNumb, this.sm2CardSessionTimeout);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CardConf [p11LibPath=");
        builder.append(this.sm2P11LibPath);
        builder.append(", p11Password=");
        builder.append(this.sm2P11Password);
        builder.append(", cardType=");
        builder.append(this.sm2CardType);
        builder.append(", cardToken=");
        builder.append(this.sm2CardToken);
        builder.append(", cardSessionNumb=");
        builder.append(this.sm2CardSessionNumb);
        builder.append(", sm2CardSessionTimeout=");
        builder.append(this.sm2CardSessionTimeout);
        builder.append(", sm2cardImplClass=");
        builder.append(this.sm2cardImplClass);
        builder.append(", rsacardImplClass=");
        builder.append(this.rsacardImplClass);
        builder.append("]");
        return builder.toString();
    }
}

