/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.test.TestExt;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;

final class SM2KTest {
    static final String sm2FileText = "MIIDfAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDDYQoRRu6L+lmHg0SOynJgW0OzlRPkNcY0Js9nnKMnl/4ahDJu0DA72iFLsTdIYftYwggMsBgoqgRzPVQYBBAIBBIIDHDCCAxgwggK9oAMCAQICBTABAnExMAwGCCqBHM9VAYN1BQAwKzELMAkGA1UEBhMCQ04xHDAaBgNVBAoME0NGQ0EgU00yIFRFU1QgT0NBMjEwHhcNMTUwNDAxMDI0NzI4WhcNMTYwNDAxMDI0NzI4WjB0MQswCQYDVQQGEwJDTjENMAsGA1UECgwEQ01CQzESMBAGA1UECwwJQ01CQ19EQ01TMRUwEwYDVQQLDAxJbmRpdmlkdWFsLTExKzApBgNVBAMMIjAzMDVAMDk0NTkxNDM2MTc5MjY0M0B1c2VyMTE1ODI1QDEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARD8XhkCu3ngLY6ojk6nWfPEAqd6vcttD92gaaOGcKfAtKRwtfxkdw5Z6EZ/T4CkrsZVkKQqFnC4J3h3g8UjeJMo4IBgTCCAX0wHwYDVR0jBBgwFoAU4n62ELuU6xXmrtEVCv/o16BXOZ0wSAYDVR0gBEEwPzA9BghggRyG7yoCAjAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTEzLmh0bTCBzgYDVR0fBIHGMIHDMIGToIGQoIGNhoGKbGRhcDovLzIxMC43NC40MS4xNjE6Mzg5L2NuPWNybDI1LE9VPVNNMixPVT1DUkwsTz1DRkNBIFNNMiBURVNUIE9DQTIxLEM9Q04/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdD9iYXNlP29iamVjdGNsYXNzPWNSTERpc3RyaWJ1dGlvblBvaW50MCugKaAnhiVodHRwOi8vMjEwLjc0LjQxLjg3L0NSTC9TTTIvY3JsMjUuY3JsMAsGA1UdDwQEAwID6DAdBgNVHQ4EFgQUVnCnXmNxFTBEckbZvMae92RwPaAwEwYDVR0lBAwwCgYIKwYBBQUHAwIwDAYIKoEcz1UBg3UFAANHADBEAiA7UhQYFiRFVmM6qBQP6VdYf2Itd8/qqcJgajy1cKIc1AIgIbHXJ5jQG2OxMZKKMbGxnpVkbQPzS6o6oMmEiQH3s1Y=";
    static final String sm2FilePass = "123123";

    SM2KTest() {
    }

    public static void main(String[] args) throws Exception {
        X509Cert recvcert = CertUtil.getCertFromSM2(sm2FileText.getBytes());
        SM2PrivateKey priKey = KeyUtil.getPrivateKeyFromSM2(sm2FileText.getBytes(), sm2FilePass);
        SM2PublicKey pubKey = (SM2PublicKey)recvcert.getPublicKey();
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        byte[] hashValue = Base64.decode("jfAhbn6vtPgRR3qdjJXKOi3PLSuDIBgoRp6Ij5p7Al0=");
        byte[] signData = session.signByHash(new Mechanism("sm3WithSM2Encryption"), priKey, hashValue);
        boolean verify = session.verifyByHash(new Mechanism("sm3WithSM2Encryption"), pubKey, hashValue, signData);
        TestExt.err(verify);
        TestExt.err(signData.length);
        String pubXY = Hex.toHexString(pubKey.getPubX()) + Hex.toHexString(pubKey.getPubY());
        TestExt.err("XY: " + pubXY);
        TestExt.err("SV: " + Hex.toHexString(signData));
        TestExt.err("XY: " + Base64.toBase64String(Hex.decode(pubXY)));
        TestExt.err("SV: " + Base64.toBase64String(signData));
    }

    static final byte[] buildExternalData(byte[] sourceData, byte[] pubXY) {
        byte[] sourceCardData = new byte[sourceData.length + 64];
        System.arraycopy(pubXY, 0, sourceCardData, 0, 64);
        System.arraycopy(sourceData, 0, sourceCardData, 64, sourceData.length);
        return sourceCardData;
    }
}

