/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.CPUThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class BindFrame {
    final AtomicLong finished = new AtomicLong(0L);
    final LinkedBlockingQueue<String> check = new LinkedBlockingQueue();

    public static void main(String[] args) throws Exception {
        BindFrame main = new BindFrame();
        main.run(args);
    }

    public void run(String[] args) throws Exception {
        CPUThread xx = new CPUThread();
        xx.setDaemon(true);
        xx.start();
        long seconds = 30L;
        long binds = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("seconds")) {
                seconds = Integer.parseInt(args[i].substring("seconds".length(), args[i].length()));
            }
            if (!args[i].startsWith("binds")) continue;
            int num = Integer.parseInt(args[i].substring("binds".length(), args[i].length()));
            binds = (long)num > binds ? binds : (long)num;
        }
        TestExt.err(String.format(">>>>>>seconds: %d,binds: %d", seconds, binds));
        BufferedReader commandsReader = null;
        commandsReader = new BufferedReader(new FileReader("TestData/commands.txt"));
        String commandLine = null;
        while ((commandLine = commandsReader.readLine()) != null) {
            if (!commandLine.startsWith("command")) continue;
            commandLine = commandLine.substring(1 + commandLine.indexOf(61));
            TestExt.err();
            TestExt.err();
            TestExt.err();
            TestExt.err(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            TestExt.err(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            TestExt.err("commandLine: " + commandLine);
            TestExt.err(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            TestExt.err(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.exec(commandLine, seconds, binds);
        }
        if (commandsReader != null) {
            commandsReader.close();
        }
    }

    final void exec(String commandName, long seconds, long binds) throws Exception {
        int i;
        String[] commands = commandName.split(":");
        int numProcess = Integer.parseInt(commands[0]);
        String[] args = commands[1].split(" ");
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String[] command = new String[3 + args.length];
        command[0] = java;
        command[1] = "-classpath";
        command[2] = classpath;
        System.arraycopy(args, 0, command, 3, args.length);
        long[] avgs = new long[numProcess];
        long[] alls = new long[numProcess];
        boolean bindind = binds > 0L && System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        int processers = Runtime.getRuntime().availableProcessors();
        this.finished.set(0L);
        Process[] procs = new Process[numProcess];
        for (i = 0; i < numProcess; ++i) {
            if (bindind) {
                long core = (1L + (long)i % binds) % (long)processers;
                String[] env = new String[]{"bind.time=" + seconds, "bind.proc=" + i, "bind.core=" + core};
                String[] cmd = new String[3 + command.length];
                System.arraycopy(command, 0, cmd, 3, command.length);
                cmd[0] = "taskset";
                cmd[1] = "-c";
                cmd[2] = "" + core;
                TestExt.err(Arrays.asList(cmd));
                this.monitor(procs, i, seconds, avgs, alls, cmd, env);
                continue;
            }
            TestExt.err(Arrays.asList(command));
            String[] env = new String[]{"bind.time=" + seconds, "bind.proc=" + i, "bind.core=0"};
            this.monitor(procs, i, seconds, avgs, alls, command, env);
        }
        this.check.poll(10L + seconds, TimeUnit.SECONDS);
        for (i = 0; i < procs.length; ++i) {
            if (procs[i] == null) continue;
            try {
                procs[i].destroy();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final void monitor(final Process[] procs, final int index, long runtime, final long[] avgs, final long[] alls, final String[] cmd, final String[] env) throws IOException {
        final long testTime = runtime * 1000000000L;
        Thread eThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Process process;
                    procs[index] = process = Runtime.getRuntime().exec(cmd, env);
                    final ExecutorService cachedThreadPool = Executors.newFixedThreadPool(2);
                    try {
                        Thread iThread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                    String readLine = null;
                                    long startTime = System.nanoTime();
                                    while (System.nanoTime() - startTime < testTime && (readLine = br.readLine()) != null) {
                                        if (!readLine.startsWith("@Agerage")) continue;
                                        cachedThreadPool.execute(new MyRunnable(readLine, avgs, alls, cmd));
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        iThread.setDaemon(true);
                        iThread.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String readline = null;
                    long startTime = System.nanoTime();
                    while (System.nanoTime() - startTime < testTime && (readline = br.readLine()) != null) {
                        if (readline.startsWith("@Agerage")) {
                            cachedThreadPool.execute(new MyRunnable(readline, avgs, alls, cmd));
                            continue;
                        }
                        if (readline.startsWith("@F")) {
                            long finish = BindFrame.this.finished.incrementAndGet();
                            if (finish != (long)avgs.length) break;
                            BindFrame.this.check.offer("@Finished");
                            break;
                        }
                        TestExt.err(readline);
                    }
                    process.destroy();
                    cachedThreadPool.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        eThread.setDaemon(true);
        eThread.start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        TestExt.err("finalize");
    }

    static final class MyRunnable
    implements Runnable {
        final String readLine;
        final long[] avgs;
        final long[] alls;
        final String[] commands;

        MyRunnable(String readLine, long[] avgs, long[] alls, String[] commands) {
            this.readLine = readLine.substring(10);
            this.avgs = avgs;
            this.alls = alls;
            this.commands = commands;
        }

        public void run() {
            StringTokenizer tokens = new StringTokenizer(this.readLine, ",");
            int proc = 0;
            int avgx = 0;
            int allx = 0;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.startsWith("proc")) {
                    proc = Integer.parseInt(token.substring(5, token.length()).trim());
                }
                if (token.startsWith("tps-avg")) {
                    avgx = Integer.parseInt(token.substring(8, token.indexOf(64)).trim());
                }
                if (!token.startsWith("tps-all")) continue;
                allx = Integer.parseInt(token.substring(8, token.indexOf(64)).trim());
            }
            this.avgs[proc] = avgx;
            this.alls[proc] = allx;
            long avg = 0L;
            for (int i = 0; i < this.avgs.length; ++i) {
                avg += this.avgs[i];
            }
            long all = 0L;
            for (int i = 0; i < this.alls.length; ++i) {
                all += this.alls[i];
            }
            StringBuffer strBuffer = new StringBuffer();
            int commandsLen = this.commands.length;
            if (commandsLen > 9) {
                strBuffer.append(this.commands[9] + " ");
            }
            if (commandsLen > 10) {
                strBuffer.append(this.commands[10] + " ");
            }
            if (commandsLen > 11) {
                strBuffer.append(this.commands[11] + " ");
            }
            if (commandsLen > 12) {
                strBuffer.append(this.commands[12] + " ");
            }
            if (commandsLen > 13) {
                strBuffer.append(this.commands[13] + " ");
            }
            if (commandsLen > 14) {
                strBuffer.append(this.commands[14] + " ");
            }
            TestExt.err(strBuffer.toString() + "##" + String.format("<<<<<<avg=%-7d,all=%-7d [%s]", avg, all, this.readLine));
        }
    }
}

