/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.dummy;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.system.SecureRandoms;
import java.security.SecureRandom;

public final class PKCS1V15Encoding {
    PKCS1V15Encoding() {
    }

    public static final byte[] encodeForPrivatekeySign(byte[] digestInfoBytes, int mLength) throws CardException {
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CardException("encodeForPrivatekeySign missing digestInfoBytes");
        }
        if (digestInfoBytes.length > mLength - 11) {
            throw new CardException("encodeForPrivatekeySign digestInfoLength required less then " + (mLength - 11));
        }
        byte[] block = new byte[mLength];
        block[0] = 0;
        block[1] = 1;
        int datLength = digestInfoBytes.length;
        int lastPadding = block.length - datLength - 1;
        for (int i = 2; i < lastPadding; ++i) {
            block[i] = -1;
        }
        block[lastPadding] = 0;
        System.arraycopy(digestInfoBytes, 0, block, block.length - datLength, datLength);
        return block;
    }

    public static final byte[] decodeForPublicKeyVerify(byte[] decryptBytes, int mLength) throws CardException {
        int index;
        if (decryptBytes == null || decryptBytes.length == 0) {
            throw new CardException("missing decryptBytes");
        }
        if (decryptBytes.length != mLength) {
            throw new CardException("decodeForPublicKeyVerify decryptLength required equal  " + mLength);
        }
        if (decryptBytes[0] != 0) {
            throw new CardException("decodeForPublicKeyVerify decryptBytes[0] required pad value 0x00, but has value: " + decryptBytes[0]);
        }
        if (decryptBytes[1] != 1) {
            throw new CardException("decodeForPublicKeyVerify decryptBytes[1] required pad value 0x01, but has value: " + decryptBytes[1]);
        }
        for (index = 2; index < decryptBytes.length && decryptBytes[index] != 0; ++index) {
            if (decryptBytes[index] == -1) continue;
            throw new CardException("decodeForPublicKeyVerify decryptBytes[" + index + "] required pad value 0xff, but has value: " + decryptBytes[index]);
        }
        if (++index < 10) {
            throw new CardException("decodeForPublicKeyVerify decryptBytes has small padding: " + (index - 2));
        }
        if (index > decryptBytes.length) {
            throw new CardException("decodeForPublicKeyVerify decryptBytes has large padding: " + (index - 2));
        }
        byte[] message = new byte[decryptBytes.length - index];
        System.arraycopy(decryptBytes, index, message, 0, message.length);
        return message;
    }

    public static final byte[] encodeForPublicKeyEncrypt(byte[] sourceData, int mLength) throws CardException {
        if (sourceData == null || sourceData.length == 0) {
            throw new CardException("encodeForPublicKeyEncrypt missing sourceData");
        }
        if (sourceData.length > mLength - 11) {
            throw new CardException("encodeForPublicKeyEncrypt sourceData required less then " + (mLength - 11));
        }
        int datLength = sourceData.length;
        byte[] paddings = new byte[mLength - datLength];
        SecureRandom random = SecureRandoms.getInstance().newSecureRandom();
        random.nextBytes(paddings);
        int last = paddings.length - 1;
        for (int index = 2; index < last; ++index) {
            while (paddings[index] == 0) {
                paddings[index] = (byte)random.nextInt();
            }
        }
        byte[] block = new byte[mLength];
        System.arraycopy(paddings, 0, block, 0, paddings.length);
        block[0] = 0;
        block[1] = 2;
        block[paddings.length - 1] = 0;
        System.arraycopy(sourceData, 0, block, block.length - datLength, datLength);
        return block;
    }

    public static final byte[] decodeForPrivateKeyDecrypt(byte[] decryptBytes, int mLength) throws CardException {
        int index;
        if (decryptBytes == null || decryptBytes.length == 0) {
            throw new CardException("decodeForPrivateKeyDecrypt missing decryptBytes");
        }
        if (decryptBytes.length != mLength) {
            throw new CardException("decodeForPrivateKeyDecrypt decryptLength required equal  " + mLength);
        }
        if (decryptBytes[0] != 0) {
            throw new CardException("decodeForPrivateKeyDecrypt decryptBytes[0] required pad value 0x00, but has value: " + decryptBytes[0]);
        }
        if (decryptBytes[1] != 2) {
            throw new CardException("decodeForPrivateKeyDecrypt decryptBytes[1] required pad value 0x02, but has value: " + decryptBytes[1]);
        }
        for (index = 2; index < decryptBytes.length && decryptBytes[index] != 0; ++index) {
        }
        if (++index < 10) {
            throw new CardException("decodeForPrivateKeyDecrypt decryptBytes has small padding: " + (index - 2));
        }
        if (index > decryptBytes.length) {
            throw new CardException("decodeForPrivateKeyDecrypt decryptBytes has large padding: " + (index - 2));
        }
        byte[] message = new byte[decryptBytes.length - index];
        System.arraycopy(decryptBytes, index, message, 0, message.length);
        return message;
    }
}

