/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.dummy;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardOperationException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.IRSACard;
import cfca.sadk.lib.crypto.card.dummy.DummyRSAPrivateKey;
import cfca.sadk.lib.crypto.card.dummy.DummyRSAPublicKey;
import cfca.sadk.lib.crypto.card.dummy.PKCS1V15Encoding;
import cfca.sadk.system.SADKDebugger;
import cryptokit.jni.JNIRSA;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public final class DummyRSACard
implements IRSACard {
    static final Logger logger = LoggerFactory.getLogger(DummyRSACard.class);

    public final void initLib(Object param) throws CardException {
    }

    public KeyPair generateKeyPair(boolean isExport, int bitLength, int keyIndex, int keyUsage) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("RSAGenerateKeyPair>>>>>>Running: isExport=%s,bitLength=%s,keyIndex=%s,keyUsage=%s", isExport, bitLength, keyIndex, keyUsage));
        }
        try {
            KeyPair keypair = cfca.sadk.lib.crypto.jni.JNIRSA.RSAGenerateKeyPair(bitLength);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAGenerateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            KeyPair output = new KeyPair(new DummyRSAPublicKey((RSAPublicKey)keypair.getPublic()), new DummyRSAPrivateKey((RSAPrivateKey)keypair.getPrivate()));
            return output;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                throw new CardException("RSAGenerateKeyPair failure: " + e.getMessage(), e);
            }
            throw new CardException(e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            }
            throw new CardException("RSAGenerateKeyPair failure: " + e.getMessage(), e);
        }
    }

    public final byte[] signByHash(PrivateKey privateKey, byte[] digestInfoBytes) throws CardException {
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSASignByHash>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n digestInfoBytes: ");
            buffer.append(SADKDebugger.dump(digestInfoBytes));
            logger.debug(buffer.toString());
        }
        DummyRSAPrivateKey caviumPrivateKey = this.convertPrivateKey(privateKey);
        int moduleLength = caviumPrivateKey.moduleBytesLength;
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CardParameterException("RSASignByHash<<<<<<missing hashValue");
        }
        if (digestInfoBytes.length < 16 || digestInfoBytes[0] != 48) {
            throw new CardParameterException("RSASignByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(digestInfoBytes));
        }
        if (digestInfoBytes.length > moduleLength - 11) {
            throw new CardParameterException("RSASignByHash<<<<<<invalid hashLength: " + digestInfoBytes.length + ",limitLength=" + (moduleLength - 11));
        }
        byte[] signData = new byte[caviumPrivateKey.moduleBytesLength];
        try {
            byte[] pkcs1Encoding = PKCS1V15Encoding.encodeForPrivatekeySign(digestInfoBytes, moduleLength);
            operationResult = JNIRSA.dowithPrivateKey((byte[])pkcs1Encoding, (byte[])caviumPrivateKey.jniEncodedBytes, (byte[])signData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSASignByHash<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("RSASignByHash<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSASignByHash<<<<<<operation failure", e);
            }
            throw new CardOperationException("RSASignByHash<<<<<<operation failure", e);
        }
        if (!operationResult) {
            if (logger.isErrorEnabled()) {
                logger.error("RSASignByHash<<<<<<operation failure with operationResult=" + operationResult);
            }
            throw new CardException("RSASignByHash<<<<<<operation failure with operationResult=" + operationResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RSASignByHash<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    public final boolean verifyByHash(PublicKey publicKey, byte[] digestInfoBytes, byte[] signData) throws CardException {
        byte[] returnDecryptBytes;
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSAVerifyByHash>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n digestInfoBytes: ");
            buffer.append(SADKDebugger.dump(digestInfoBytes));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            logger.debug(buffer.toString());
        }
        DummyRSAPublicKey caviumPublicKey = this.convertPublicKey(publicKey);
        int moduleLength = caviumPublicKey.moduleBytesLength;
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<missing hashValue");
        }
        if (digestInfoBytes.length < 16 || digestInfoBytes[0] != 48) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(digestInfoBytes));
        }
        if (digestInfoBytes.length > moduleLength - 11) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<invalid hashLength: " + digestInfoBytes.length + ",limitLength=" + (moduleLength - 11));
        }
        if (signData == null || signData.length == 0) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<missing signedData");
        }
        if (signData.length != moduleLength) {
            throw new CardParameterException("RSAVerifyByHash<<<<<<invalid signedLength: " + signData.length + ",moduleLength=" + moduleLength);
        }
        byte[] decryptData = new byte[moduleLength];
        try {
            operationResult = JNIRSA.dowithPublicKey((byte[])signData, (byte[])caviumPublicKey.jniEncodedBytes, (byte[])decryptData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAVerifyByHash<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("RSAVerifyByHash<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAVerifyByHash<<<<<<operation failure", e);
            }
            throw new CardOperationException("RSAVerifyByHash<<<<<<operation failure", e);
        }
        if (!operationResult) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAVerifyByHash<<<<<<operation failure with operationResult=" + operationResult);
            }
            throw new CardException("RSAVerifyByHash<<<<<<operation failure with operationResult=" + operationResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RSAVerifyByHash<<<<<<decryptData=" + SADKDebugger.dump(decryptData));
        }
        try {
            returnDecryptBytes = PKCS1V15Encoding.decodeForPublicKeyVerify(decryptData, moduleLength);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAVerifyByHash<<<<<<operation failure when delDecryptPKCS1Padding", (Throwable)e);
            }
            throw new CardException("RSAVerifyByHash<<<<<<operation failure when delDecryptPKCS1Padding", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RSAVerifyByHash<<<<<<returnDecryptBytes=" + SADKDebugger.dump(returnDecryptBytes));
        }
        boolean verifyResult = Arrays.equals(digestInfoBytes, returnDecryptBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("RSAVerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CardException {
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSAEncrypt>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        DummyRSAPublicKey caviumPublicKey = this.convertPublicKey(publicKey);
        int moduleLength = caviumPublicKey.moduleBytesLength;
        if (sourceData == null || sourceData.length == 0) {
            throw new CardParameterException("RSAEncrypt<<<<<<missing sourceData");
        }
        if (sourceData.length > moduleLength - 11) {
            throw new CardParameterException("RSAEncrypt<<<<<<invalid sourceLength: " + sourceData.length + ",limitLength=" + (moduleLength - 11));
        }
        byte[] encryptData = new byte[moduleLength];
        try {
            byte[] pkcs1Encoding = PKCS1V15Encoding.encodeForPublicKeyEncrypt(sourceData, moduleLength);
            operationResult = JNIRSA.dowithPublicKey((byte[])pkcs1Encoding, (byte[])caviumPublicKey.jniEncodedBytes, (byte[])encryptData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAEncrypt<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("RSAEncrypt<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAEncrypt<<<<<<operation failure", e);
            }
            throw new CardOperationException("RSAEncrypt<<<<<<operation failure", e);
        }
        if (!operationResult) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAEncrypt<<<<<<operation failure: operationResult=" + operationResult);
            }
            throw new CardException("RSAEncrypt<<<<<<operation failure: operationResult=" + operationResult);
        }
        return encryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CardException {
        byte[] returnDecryptBytes;
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSADecrypt>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        DummyRSAPrivateKey caviumPrivateKey = this.convertPrivateKey(privateKey);
        int moduleLength = caviumPrivateKey.moduleBytesLength;
        if (encryptData == null || encryptData.length == 0) {
            throw new CardParameterException("RSADecrypt<<<<<<missing encryptData");
        }
        if (encryptData.length != moduleLength) {
            throw new CardParameterException("RSADecrypt<<<<<<invalid encryptLength: " + encryptData.length + ",moduleLength=" + moduleLength);
        }
        byte[] decryptData = new byte[moduleLength];
        try {
            operationResult = JNIRSA.dowithPrivateKey((byte[])encryptData, (byte[])caviumPrivateKey.jniEncodedBytes, (byte[])decryptData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSADecrypt<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("RSADecrypt<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSADecrypt<<<<<<operation failure", e);
            }
            throw new CardOperationException("RSADecrypt<<<<<<operation failure", e);
        }
        if (!operationResult) {
            if (logger.isErrorEnabled()) {
                logger.error("RSADecrypt<<<<<<operation failure: operationResult=" + operationResult);
            }
            throw new CardException("RSADecrypt<<<<<<operation failure: operationResult=" + operationResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RSADecrypt<<<<<<decryptData=" + SADKDebugger.dump(decryptData));
        }
        try {
            returnDecryptBytes = PKCS1V15Encoding.decodeForPrivateKeyDecrypt(decryptData, moduleLength);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSADecrypt<<<<<<operation failure when delDecryptPKCS1Padding", (Throwable)e);
            }
            throw new CardException("RSADecrypt<<<<<<operation failure when delDecryptPKCS1Padding", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RSADecrypt<<<<<<Finished: returnDecryptBytes=" + SADKDebugger.dump(returnDecryptBytes));
        }
        return returnDecryptBytes;
    }

    private final DummyRSAPrivateKey convertPrivateKey(PrivateKey privateKey) throws CardException {
        if (privateKey == null) {
            throw new CardParameterException("missing privateKey");
        }
        DummyRSAPrivateKey outputPrivateKey = null;
        if (privateKey instanceof DummyRSAPrivateKey) {
            outputPrivateKey = (DummyRSAPrivateKey)privateKey;
        } else if (privateKey instanceof RSAPrivateKey) {
            outputPrivateKey = new DummyRSAPrivateKey((RSAPrivateKey)privateKey);
        } else {
            throw new CardParameterException("invalid privateKey(required RSAPrivateKey)");
        }
        return outputPrivateKey;
    }

    private final DummyRSAPublicKey convertPublicKey(PublicKey publicKey) throws CardException {
        if (publicKey == null) {
            throw new CardParameterException("missing publicKey");
        }
        DummyRSAPublicKey outputPublicKey = null;
        if (publicKey instanceof DummyRSAPublicKey) {
            outputPublicKey = (DummyRSAPublicKey)publicKey;
        } else if (publicKey instanceof RSAPublicKey) {
            outputPublicKey = new DummyRSAPublicKey((RSAPublicKey)publicKey);
        } else {
            throw new CardParameterException("invalid publicKey(required RSAPublicKey)");
        }
        return outputPublicKey;
    }

    public final void unInitLib(Object param) {
    }
}

