/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardOperationException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.ISM2Card;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.lib.crypto.card.c200.SM2CardP11;
import cfca.sadk.lib.crypto.card.c200.SM2CardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.lib.crypto.card.dummy.DummySM2Card;
import cfca.sadk.system.SADKDebugger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class C200SM2Card
implements ISM2Card {
    static final Logger logger = LoggerFactory.getLogger(C200SM2Card.class);
    private SM2CardP11 control;
    final DummySM2Card dummy = new DummySM2Card();

    public void initLib(Object param) throws CardException {
        if (param == null) {
            throw new CardException("missing SM2CardInfo");
        }
        if (!(param instanceof SM2CardInfo)) {
            throw new CardException("required SM2CardInfo");
        }
        this.control = new SM2CardP11((SM2CardInfo)param);
    }

    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage) throws CardException {
        logger.debug(String.format("SM2GenerateKeyPair>>>>>>Running: isExport=%s,keyIndex=%s,keyUsage=%s", isExport, keyIndex, keyUsage));
        if (this.control == null) {
            throw new CardException("SM2CardP11 not initLib");
        }
        try {
            KeyPair keypair = this.control.generateKeyPair(new GenKeyAttribute(isExport, keyIndex, keyUsage));
            if (logger.isDebugEnabled()) {
                logger.debug("SM2GenerateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw new CardException("SM2GenerateKeyPair<<<<<<Failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            }
            throw new CardException("SM2GenerateKeyPair<<<<<<Failure", e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] sm3HashValue) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2SignByHash>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n sm3HashValue: ");
            buffer.append(SADKDebugger.dump(sm3HashValue));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("SM2CardP11 not initLib");
        }
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CardParameterException("SM2SignByHash<<<<<<missing hashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CardParameterException("SM2SignByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(sm3HashValue));
        }
        SM2CardPrivateKey cardKey = this.control.SM2CardPrivateKey(privateKey);
        byte[] signData = null;
        if (cardKey.internal) {
            try {
                signData = this.control.SM2CardSign(cardKey, sm3HashValue);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2SignByHash<<<<<<operation failure", (Throwable)e);
                }
                throw new CardOperationException("SM2SignByHash<<<<<<operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2SignByHash<<<<<<operation failure", e);
                }
                throw new CardOperationException("SM2SignByHash<<<<<<operation failure", e);
            }
        } else {
            signData = this.dummy.signByHash(privateKey, sm3HashValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2SignByHash<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] sm3HashValue, byte[] signData) throws CardException {
        boolean verifyResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2VerifyByHash>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sm3HashValue: ");
            buffer.append(SADKDebugger.dump(sm3HashValue));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("SM2CardP11 not initLib");
        }
        SM2CardPublicKey cardKey = this.control.SM2CardPublicKey(publicKey);
        if (cardKey.internal) {
            try {
                verifyResult = this.control.SM2CardVerify(cardKey, sm3HashValue, signData);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2VerifyByHash<<<<<<operation failure", (Throwable)e);
                }
                throw new CardOperationException("SM2VerifyByHash<<<<<<operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2VerifyByHash<<<<<<operation failure", e);
                }
                throw new CardOperationException("SM2VerifyByHash<<<<<<operation failure", e);
            }
        }
        try {
            verifyResult = this.control.SM2CardExternalVerify(cardKey, sm3HashValue, signData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2VerifyByHash<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("SM2VerifyByHash<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2VerifyByHash<<<<<<operation failure", e);
            }
            throw new CardOperationException("SM2VerifyByHash<<<<<<operation failure", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2VerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2Encrypt>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("SM2CardP11 not initLib");
        }
        SM2CardPublicKey cardKey = this.control.SM2CardPublicKey(publicKey);
        byte[] encryptData = null;
        if (cardKey.internal && cardKey.keyUsage == 1) {
            try {
                encryptData = this.control.SM2CardEncrypt(cardKey, sourceData);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2Encrypt<<<<<<operation failure", (Throwable)e);
                }
                throw new CardOperationException("SM2Encrypt<<<<<<operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2Encrypt<<<<<<operation failure", e);
                }
                throw new CardOperationException("SM2Encrypt<<<<<<operation failure", e);
            }
        }
        try {
            encryptData = this.control.SM2CardExternalEncrypt(cardKey, sourceData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2Encrypt<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("SM2Encrypt<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2Encrypt<<<<<<operation failure", e);
            }
            throw new CardOperationException("SM2Encrypt<<<<<<operation failure", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Encrypt<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
        }
        return encryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2Decrypt>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("SM2CardP11 not initLib");
        }
        SM2CardPrivateKey cardKey = this.control.SM2CardPrivateKey(privateKey);
        byte[] decryptData = null;
        if (cardKey.internal) {
            try {
                decryptData = this.control.SM2CardDecrypt(cardKey, encryptData);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2Decrypt<<<<<< operation failure", (Throwable)e);
                }
                throw new CardOperationException("SM2Decrypt<<<<<< operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("SM2Decrypt<<<<<< operation failure", e);
                }
                throw new CardOperationException("SM2Decrypt<<<<<< operation failure", e);
            }
        } else {
            decryptData = this.dummy.decrypt(privateKey, encryptData);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Encrypt<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
        }
        return decryptData;
    }

    public void unInitLib(Object param) {
    }

    public long loginSM2Card(String p11Password) throws CardException {
        return this.control.loginSM2Card(p11Password);
    }

    public PublicKey expoertEncPublicKey() throws CardException {
        PublicKey encPubKey = null;
        try {
            encPubKey = this.control.expoertEncPublicKey();
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("expoertEncPublicKey<<<<<< operation failure", (Throwable)e);
            }
            throw new CardOperationException("expoertEncPublicKey<<<<<< operation failure", e);
        }
        return encPubKey;
    }

    public boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws CardException {
        boolean result = false;
        try {
            result = this.control.importSM2KeyPair(encryptKeyData, CKID);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("importSM2KeyPair<<<<<< operation failure", (Throwable)e);
                StringBuffer buffer = new StringBuffer();
                buffer.append("importSM2KeyPair>>>>>>Running");
                buffer.append("\n encryptKeyData: ");
                buffer.append(SADKDebugger.dump(encryptKeyData));
                buffer.append("\n CKID: " + CKID);
                logger.error(buffer.toString());
            }
            throw new CardOperationException("importSM2KeyPair<<<<<< operation failure", e);
        }
        return result;
    }
}

