/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cgb.toolkit;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public final class SM4Toolkit {
    static final Logger logger = LoggerFactory.getLogger(SM4Toolkit.class);
    private ParametersWithIV params = null;

    public final boolean SM4Init(byte[] key, byte[] iv) throws PKIException {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("null/length not allowed for key");
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException("null/length not allowed for iv");
        }
        this.params = new ParametersWithIV(new KeyParameter(key), iv);
        return true;
    }

    public final byte[] SM4EncryptData(byte[] data) throws PKIException {
        return this.SM4Message(true, data);
    }

    public final byte[] SM4DecryptData(byte[] data) throws PKIException {
        return this.SM4Message(false, data);
    }

    public final boolean SM4EncryptFile(String inFile, String outFile) throws PKIException {
        return this.SM4File(true, inFile, outFile);
    }

    public final boolean SM4DecryptFile(String inFile, String outFile) throws PKIException {
        return this.SM4File(false, inFile, outFile);
    }

    private final byte[] SM4Message(boolean isEncrypted, byte[] data) throws PKIException {
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        if (this.params == null) {
            throw new PKIException("params not inited");
        }
        try {
            PaddedBufferedBlockCipher engine = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            engine.init(isEncrypted, this.params);
            int len = engine.getOutputSize(data.length);
            byte[] buffer = new byte[len];
            int dLength = engine.processBytes(data, 0, data.length, buffer, 0);
            int fLength = engine.doFinal(buffer, dLength);
            int rLength = dLength + fLength;
            if (rLength < len) {
                byte[] out = new byte[rLength];
                System.arraycopy(buffer, 0, out, 0, rLength);
                return out;
            }
            return buffer;
        }
        catch (Exception e) {
            throw new PKIException("SM4 operation failure", e);
        }
    }

    private final boolean SM4File(boolean isEncrypted, String inFile, String outFile) throws PKIException {
        if (inFile == null) {
            throw new IllegalArgumentException("null not allowed for inFile");
        }
        if (outFile == null) {
            throw new IllegalArgumentException("null not allowed for outFile");
        }
        if (this.params == null) {
            throw new PKIException("params not inited");
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int oLength;
            int rLength;
            in = new FileInputStream(inFile);
            out = new FileOutputStream(outFile);
            PaddedBufferedBlockCipher engine = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            engine.init(isEncrypted, this.params);
            byte[] inBytes = new byte[65536];
            byte[] ouBytes = new byte[16 + inBytes.length];
            while ((rLength = in.read(inBytes, 0, inBytes.length)) != -1) {
                oLength = engine.processBytes(inBytes, 0, rLength, ouBytes, 0);
                out.write(ouBytes, 0, oLength);
                out.flush();
            }
            oLength = engine.doFinal(ouBytes, 0);
            if (oLength > 0) {
                out.write(ouBytes, 0, oLength);
                out.flush();
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new PKIException("SM4 operation failure", e);
        }
        catch (Exception e) {
            throw new PKIException("SM4 operation failure", e);
        }
        finally {
            block21: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) break block21;
                        logger.error("SM4File closeFile failure", (Throwable)e);
                    }
                }
            }
        }
    }
}

