/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.okhttp3.internal.huc;

import cn.unitid.okhttp3.Call;
import cn.unitid.okhttp3.Callback;
import cn.unitid.okhttp3.Dispatcher;
import cn.unitid.okhttp3.Handshake;
import cn.unitid.okhttp3.Headers;
import cn.unitid.okhttp3.HttpUrl;
import cn.unitid.okhttp3.Interceptor;
import cn.unitid.okhttp3.OkHttpClient;
import cn.unitid.okhttp3.Request;
import cn.unitid.okhttp3.Response;
import cn.unitid.okhttp3.internal.Internal;
import cn.unitid.okhttp3.internal.JavaNetHeaders;
import cn.unitid.okhttp3.internal.URLFilter;
import cn.unitid.okhttp3.internal.Version;
import cn.unitid.okhttp3.internal.http.HttpDate;
import cn.unitid.okhttp3.internal.http.HttpHeaders;
import cn.unitid.okhttp3.internal.http.HttpMethod;
import cn.unitid.okhttp3.internal.http.StatusLine;
import cn.unitid.okhttp3.internal.huc.BufferedRequestBody;
import cn.unitid.okhttp3.internal.huc.OutputStreamRequestBody;
import cn.unitid.okhttp3.internal.huc.StreamedRequestBody;
import cn.unitid.okhttp3.internal.platform.Platform;
import cn.unitid.okio.Buffer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class OkHttpURLConnection
extends HttpURLConnection
implements Callback {
    public static final String SELECTED_PROTOCOL = Platform.get().getPrefix() + "-Selected-Protocol";
    public static final String RESPONSE_SOURCE = Platform.get().getPrefix() + "-Response-Source";
    private static final Set<String> METHODS = new LinkedHashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PATCH"));
    OkHttpClient client;
    private final NetworkInterceptor networkInterceptor = new NetworkInterceptor();
    private Headers.Builder requestHeaders = new Headers.Builder();
    private boolean executed;
    Call call;
    URLFilter urlFilter;
    private Headers responseHeaders;
    private long fixedContentLength = -1L;
    private final Object lock = new Object();
    private Response response;
    private Throwable callFailure;
    Response networkResponse;
    boolean connectPending = true;
    Proxy proxy;
    Handshake handshake;

    public OkHttpURLConnection(URL url, OkHttpClient client) {
        super(url);
        this.client = client;
    }

    public OkHttpURLConnection(URL url, OkHttpClient client, URLFilter urlFilter) {
        this(url, client);
        this.urlFilter = urlFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        if (this.executed) {
            return;
        }
        Call call = this.buildCall();
        this.executed = true;
        call.enqueue(this);
        Object object = this.lock;
        synchronized (object) {
            try {
                while (this.connectPending && this.response == null && this.callFailure == null) {
                    this.lock.wait();
                }
                if (this.callFailure != null) {
                    throw OkHttpURLConnection.propagate(this.callFailure);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.call == null) {
            return;
        }
        this.networkInterceptor.proceed();
        this.call.cancel();
    }

    @Override
    public InputStream getErrorStream() {
        try {
            Response response = this.getResponse(true);
            if (HttpHeaders.hasBody(response) && response.code() >= 400) {
                return response.body().byteStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Headers getHeaders() throws IOException {
        if (this.responseHeaders == null) {
            Response response = this.getResponse(true);
            Headers headers = response.headers();
            this.responseHeaders = headers.newBuilder().add(SELECTED_PROTOCOL, response.protocol().toString()).add(RESPONSE_SOURCE, OkHttpURLConnection.responseSourceHeader(response)).build();
        }
        return this.responseHeaders;
    }

    private static String responseSourceHeader(Response response) {
        if (response.networkResponse() == null) {
            if (response.cacheResponse() == null) {
                return "NONE";
            }
            return "CACHE " + response.code();
        }
        if (response.cacheResponse() == null) {
            return "NETWORK " + response.code();
        }
        return "CONDITIONAL_CACHE " + response.networkResponse().code();
    }

    @Override
    public String getHeaderField(int position) {
        try {
            Headers headers = this.getHeaders();
            if (position < 0 || position >= headers.size()) {
                return null;
            }
            return headers.value(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getHeaderField(String fieldName) {
        try {
            return fieldName == null ? StatusLine.get(this.getResponse(true)).toString() : this.getHeaders().get(fieldName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getHeaderFieldKey(int position) {
        try {
            Headers headers = this.getHeaders();
            if (position < 0 || position >= headers.size()) {
                return null;
            }
            return headers.name(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            return JavaNetHeaders.toMultimap(this.getHeaders(), StatusLine.get(this.getResponse(true)).toString());
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return JavaNetHeaders.toMultimap(this.requestHeaders.build(), null);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        Response response = this.getResponse(false);
        if (response.code() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        return response.body().byteStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStreamRequestBody requestBody = (OutputStreamRequestBody)this.buildCall().request().body();
        if (requestBody == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (requestBody instanceof StreamedRequestBody) {
            this.connect();
            this.networkInterceptor.proceed();
        }
        if (requestBody.isClosed()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        return requestBody.outputStream();
    }

    @Override
    public Permission getPermission() throws IOException {
        int hostPort;
        URL url = this.getURL();
        String hostname = url.getHost();
        int n = hostPort = url.getPort() != -1 ? url.getPort() : HttpUrl.defaultPort(url.getProtocol());
        if (this.usingProxy()) {
            InetSocketAddress proxyAddress = (InetSocketAddress)this.client.proxy().address();
            hostname = proxyAddress.getHostName();
            hostPort = proxyAddress.getPort();
        }
        return new SocketPermission(hostname + ":" + hostPort, "connect, resolve");
    }

    @Override
    public String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.requestHeaders.get(field);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.client = this.client.newBuilder().connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.client = this.client.newBuilder().followRedirects(followRedirects).build();
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.client.followRedirects();
    }

    @Override
    public int getConnectTimeout() {
        return this.client.connectTimeoutMillis();
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.client = this.client.newBuilder().readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public int getReadTimeout() {
        return this.client.readTimeoutMillis();
    }

    private Call buildCall() throws IOException {
        HttpUrl url;
        if (this.call != null) {
            return this.call;
        }
        this.connected = true;
        if (this.doOutput) {
            if (this.method.equals("GET")) {
                this.method = "POST";
            } else if (!HttpMethod.permitsRequestBody(this.method)) {
                throw new ProtocolException(this.method + " does not support writing");
            }
        }
        if (this.requestHeaders.get("User-Agent") == null) {
            this.requestHeaders.add("User-Agent", this.defaultUserAgent());
        }
        OutputStreamRequestBody requestBody = null;
        if (HttpMethod.permitsRequestBody(this.method)) {
            String contentType = this.requestHeaders.get("Content-Type");
            if (contentType == null) {
                contentType = "application/x-www-form-urlencoded";
                this.requestHeaders.add("Content-Type", contentType);
            }
            boolean stream = this.fixedContentLength != -1L || this.chunkLength > 0;
            long contentLength = -1L;
            String contentLengthString = this.requestHeaders.get("Content-Length");
            if (this.fixedContentLength != -1L) {
                contentLength = this.fixedContentLength;
            } else if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
            requestBody = stream ? new StreamedRequestBody(contentLength) : new BufferedRequestBody(contentLength);
            requestBody.timeout().timeout(this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        try {
            url = HttpUrl.get(this.getURL().toString());
        }
        catch (IllegalArgumentException e) {
            if (Internal.instance.isInvalidHttpUrlHost(e)) {
                UnknownHostException unknownHost = new UnknownHostException();
                unknownHost.initCause(e);
                throw unknownHost;
            }
            MalformedURLException malformedUrl = new MalformedURLException();
            malformedUrl.initCause(e);
            throw malformedUrl;
        }
        Request request = new Request.Builder().url(url).headers(this.requestHeaders.build()).method(this.method, requestBody).build();
        if (this.urlFilter != null) {
            this.urlFilter.checkURLPermitted(request.url().url());
        }
        OkHttpClient.Builder clientBuilder = this.client.newBuilder();
        clientBuilder.interceptors().clear();
        clientBuilder.interceptors().add(UnexpectedException.INTERCEPTOR);
        clientBuilder.networkInterceptors().clear();
        clientBuilder.networkInterceptors().add(this.networkInterceptor);
        clientBuilder.dispatcher(new Dispatcher(this.client.dispatcher().executorService()));
        if (!this.getUseCaches()) {
            clientBuilder.cache(null);
        }
        this.call = clientBuilder.build().newCall(request);
        return this.call;
    }

    private String defaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? OkHttpURLConnection.toHumanReadableAscii(agent) : Version.userAgent();
    }

    private static String toHumanReadableAscii(String s) {
        int c;
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if (c > 31 && c < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(s, 0, i);
            buffer.writeUtf8CodePoint(63);
            for (int j = i + Character.charCount(c); j < length; j += Character.charCount(c)) {
                c = s.codePointAt(j);
                buffer.writeUtf8CodePoint(c > 31 && c < 127 ? c : 63);
            }
            return buffer.readUtf8();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponse(boolean networkResponseOnError) throws IOException {
        Object object;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.response != null) {
                return this.response;
            }
            if (this.callFailure != null) {
                if (networkResponseOnError && this.networkResponse != null) {
                    return this.networkResponse;
                }
                throw OkHttpURLConnection.propagate(this.callFailure);
            }
        }
        Call call = this.buildCall();
        this.networkInterceptor.proceed();
        OutputStreamRequestBody requestBody = (OutputStreamRequestBody)call.request().body();
        if (requestBody != null) {
            requestBody.outputStream().close();
        }
        if (this.executed) {
            object = this.lock;
            synchronized (object) {
                try {
                    while (this.response == null && this.callFailure == null) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        this.executed = true;
        try {
            this.onResponse(call, call.execute());
        }
        catch (IOException e) {
            this.onFailure(call, e);
        }
        object = this.lock;
        synchronized (object) {
            if (this.callFailure != null) {
                throw OkHttpURLConnection.propagate(this.callFailure);
            }
            if (this.response != null) {
                return this.response;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean usingProxy() {
        if (this.proxy != null) {
            return true;
        }
        Proxy clientProxy = this.client.proxy();
        return clientProxy != null && clientProxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.getResponse(true).message();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.getResponse(true).code();
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            Platform.get().log(5, "Ignoring header " + field + " because its value was null.", null);
            return;
        }
        this.requestHeaders.set(field, newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        super.setIfModifiedSince(newValue);
        if (this.ifModifiedSince != 0L) {
            this.requestHeaders.set("If-Modified-Since", HttpDate.format(new Date(this.ifModifiedSince)));
        } else {
            this.requestHeaders.removeAll("If-Modified-Since");
        }
    }

    @Override
    public void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (value == null) {
            Platform.get().log(5, "Ignoring header " + field + " because its value was null.", null);
            return;
        }
        this.requestHeaders.add(field, value);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (!METHODS.contains(method)) {
            throw new ProtocolException("Expected one of " + METHODS + " but was " + method);
        }
        this.method = method;
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.setFixedLengthStreamingMode((long)contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.chunkLength > 0) {
            throw new IllegalStateException("Already in chunked mode");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        this.fixedContentLength = contentLength;
        ((HttpURLConnection)this).fixedContentLength = (int)Math.min(contentLength, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Call call, IOException e) {
        Object object = this.lock;
        synchronized (object) {
            this.callFailure = e instanceof UnexpectedException ? e.getCause() : e;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Call call, Response response) {
        Object object = this.lock;
        synchronized (object) {
            this.response = response;
            this.handshake = response.handshake();
            this.url = response.request().url().url();
            this.lock.notifyAll();
        }
    }

    private static IOException propagate(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new AssertionError();
    }

    final class NetworkInterceptor
    implements Interceptor {
        private boolean proceed;

        NetworkInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void proceed() {
            Object object = OkHttpURLConnection.this.lock;
            synchronized (object) {
                this.proceed = true;
                OkHttpURLConnection.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (OkHttpURLConnection.this.urlFilter != null) {
                OkHttpURLConnection.this.urlFilter.checkURLPermitted(request.url().url());
            }
            Object object = OkHttpURLConnection.this.lock;
            synchronized (object) {
                OkHttpURLConnection.this.connectPending = false;
                OkHttpURLConnection.this.proxy = chain.connection().route().proxy();
                OkHttpURLConnection.this.handshake = chain.connection().handshake();
                OkHttpURLConnection.this.lock.notifyAll();
                try {
                    while (!this.proceed) {
                        OkHttpURLConnection.this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            if (request.body() instanceof OutputStreamRequestBody) {
                OutputStreamRequestBody requestBody = (OutputStreamRequestBody)request.body();
                request = requestBody.prepareToSendRequest(request);
            }
            Response response = chain.proceed(request);
            Object object2 = OkHttpURLConnection.this.lock;
            synchronized (object2) {
                OkHttpURLConnection.this.networkResponse = response;
                OkHttpURLConnection.this.url = response.request().url().url();
            }
            return response;
        }
    }

    static final class UnexpectedException
    extends IOException {
        static final Interceptor INTERCEPTOR = new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                try {
                    return chain.proceed(chain.request());
                }
                catch (Error | RuntimeException e) {
                    throw new UnexpectedException(e);
                }
            }
        };

        UnexpectedException(Throwable cause) {
            super(cause);
        }
    }
}

