/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.util;

import cn.unitid.easypki.util.StringFormatHelper;
import cn.unitid.easypki.x509.SM2X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.util.encoders.Base64;

public class CertificateConverter {
    public static String toPEMFormat(String x509Certificate) throws IOException {
        return StringFormatHelper.toPEMString(x509Certificate, 1);
    }

    public static String toPEMFormat(X509Certificate x509Certificate) throws CertificateEncodingException {
        return StringFormatHelper.toPEMString(x509Certificate);
    }

    public static String toBase64String(X509Certificate x509Certificate) throws CertificateEncodingException {
        return Base64.toBase64String(x509Certificate.getEncoded());
    }

    public static X509Certificate fromBase64(String data) throws CertificateException {
        return CertificateConverter.fromBinary(Base64.decode(data.trim()));
    }

    public static X509Certificate fromBase64(byte[] data) throws CertificateException {
        return CertificateConverter.fromBinary(Base64.decode(data));
    }

    public static X509Certificate fromBinary(byte[] data) throws CertificateException {
        try {
            X509CertificateHolder holder = new X509CertificateHolder(data);
            AlgorithmIdentifier publicKeyAlgorithmIdentifier = holder.getSubjectPublicKeyInfo().getAlgorithm();
            String publicKeyAlgorithm = publicKeyAlgorithmIdentifier.getAlgorithm().getId();
            if ("1.2.840.10045.2.1".equals(publicKeyAlgorithm)) {
                ASN1Encodable parameters = publicKeyAlgorithmIdentifier.getParameters();
                if (parameters instanceof ASN1ObjectIdentifier) {
                    ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)parameters;
                    if (identifier.getId().equals("1.2.156.10197.1.301")) {
                        return new SM2X509Certificate(holder.toASN1Structure());
                    }
                    throw new CertificateException("\u8be5\u8bc1\u4e66\u516c\u94a5\u53c2\u6570\u4e3aEC\uff0c\u4f46\u53c2\u6570\u975eSM2\u692d\u5706\u66f2\u7ebf\u516c\u94a5\u5bc6\u7801\u7b97\u6cd51.2.156.10197.1.301");
                }
                throw new CertificateException("\u8be5\u8bc1\u4e66\u516c\u94a5\u53c2\u6570\u4e3aEC\uff0c\u4f46\u672a\u5305\u542b\u7b97\u6cd5\u53c2\u6570\uff01");
            }
        }
        catch (IOException e) {
            throw new CertificateException("failed to parse certificate");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return x509Certificate;
    }

    public static X509Certificate fromPEM(String data) throws CertificateException {
        String sep = "-----";
        String header = "-----BEGIN CERTIFICATE-----";
        String clearData = data.trim().replace("\n", "").replace("\r", "");
        if (!clearData.contains(header)) {
            throw new IllegalArgumentException("invalid pem certificate");
        }
        String[] values = clearData.split(sep);
        if (4 != values.length) {
            throw new IllegalArgumentException("invalid pem certificate");
        }
        return CertificateConverter.fromBase64(values[2]);
    }
}

