/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;
import org.bouncycastle.util.Arrays;

public class RSADigestSignature {
    private final AsymmetricBlockCipher rsaEngine = new PKCS1Encoding(new RSABlindedEngine());
    private AsymmetricKeyParameter asymmetricPubKeyParameter;
    private AsymmetricKeyParameter asymmetricPriKeyParameter;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private final AlgorithmIdentifier algId;
    private static final Hashtable oidMap = new Hashtable();

    public RSADigestSignature(Digest digest) {
        Security.addProvider(new BouncyCastleProvider());
        this.algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)oidMap.get(digest.getAlgorithmName()), DERNull.INSTANCE);
    }

    public void initSign(RSAPublicKey rsaPublicKey, RSAPrivateKey rsaPrivateKey) {
        if (rsaPrivateKey != null) {
            this.asymmetricPubKeyParameter = new RSAKeyParameters(false, rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent());
        }
        if (rsaPrivateKey == null) {
            throw new IllegalArgumentException("privateKey not allow null");
        }
        if (rsaPrivateKey instanceof BCRSAPrivateCrtKey) {
            BCRSAPrivateCrtKey bcrsaPrivateCrtKey = (BCRSAPrivateCrtKey)rsaPrivateKey;
            this.asymmetricPriKeyParameter = new RSAPrivateCrtKeyParameters(bcrsaPrivateCrtKey.getModulus(), bcrsaPrivateCrtKey.getPublicExponent(), bcrsaPrivateCrtKey.getPrivateExponent(), bcrsaPrivateCrtKey.getPrimeP(), bcrsaPrivateCrtKey.getPrimeQ(), bcrsaPrivateCrtKey.getPrimeExponentP(), bcrsaPrivateCrtKey.getPrimeExponentQ(), bcrsaPrivateCrtKey.getCrtCoefficient());
        } else if (rsaPrivateKey instanceof JCERSAPrivateKey) {
            JCERSAPrivateKey jcersaPrivateKey = (JCERSAPrivateKey)rsaPrivateKey;
            this.asymmetricPriKeyParameter = new RSAPrivateCrtKeyParameters(jcersaPrivateKey.getModulus(), ZERO, jcersaPrivateKey.getPrivateExponent(), ZERO, ZERO, ZERO, ZERO, ZERO);
        }
        this.rsaEngine.init(true, this.asymmetricPriKeyParameter);
    }

    public void initSign(RSAPrivateKey rsaPrivateKey) {
        if (rsaPrivateKey == null) {
            throw new IllegalArgumentException("rsaPrivateKey not allow null");
        }
        if (rsaPrivateKey instanceof BCRSAPrivateCrtKey) {
            BCRSAPrivateCrtKey bcrsaPrivateCrtKey = (BCRSAPrivateCrtKey)rsaPrivateKey;
            this.asymmetricPriKeyParameter = new RSAPrivateCrtKeyParameters(bcrsaPrivateCrtKey.getModulus(), bcrsaPrivateCrtKey.getPublicExponent(), bcrsaPrivateCrtKey.getPrivateExponent(), bcrsaPrivateCrtKey.getPrimeP(), bcrsaPrivateCrtKey.getPrimeQ(), bcrsaPrivateCrtKey.getPrimeExponentP(), bcrsaPrivateCrtKey.getPrimeExponentQ(), bcrsaPrivateCrtKey.getCrtCoefficient());
        } else if (rsaPrivateKey instanceof JCERSAPrivateKey) {
            JCERSAPrivateKey jcersaPrivateKey = (JCERSAPrivateKey)rsaPrivateKey;
            this.asymmetricPriKeyParameter = new RSAPrivateCrtKeyParameters(jcersaPrivateKey.getModulus(), ZERO, jcersaPrivateKey.getPrivateExponent(), ZERO, ZERO, ZERO, ZERO, ZERO);
        }
        this.initSign(this.asymmetricPubKeyParameter, this.asymmetricPriKeyParameter);
    }

    public void initSign(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.asymmetricPriKeyParameter = asymmetricKeyParameter;
        this.rsaEngine.init(true, this.asymmetricPriKeyParameter);
    }

    public void initSign(AsymmetricKeyParameter pubm, AsymmetricKeyParameter prim) {
        this.asymmetricPubKeyParameter = pubm;
        this.asymmetricPriKeyParameter = prim;
        this.rsaEngine.init(true, this.asymmetricPriKeyParameter);
    }

    public byte[] signDigest(byte[] hash) throws InvalidCipherTextException, IOException {
        byte[] data = this.derEncode(hash);
        return this.rsaEngine.processBlock(data, 0, data.length);
    }

    public void initVerify(RSAPublicKey rsaPublicKey) {
        if (rsaPublicKey == null) {
            throw new IllegalArgumentException("rsaPublicKey not allow null");
        }
        this.asymmetricPubKeyParameter = new RSAKeyParameters(false, rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent());
        this.rsaEngine.init(false, this.asymmetricPubKeyParameter);
    }

    public void initVerify(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("publicKey not allow null");
        }
        this.rsaEngine.init(false, asymmetricKeyParameter);
    }

    public boolean verify(byte[] signature, byte[] hash) {
        byte[] expected;
        byte[] expect;
        try {
            expect = this.rsaEngine.processBlock(signature, 0, signature.length);
            expected = this.derEncode(hash);
        }
        catch (Exception e) {
            return false;
        }
        if (expect.length == expected.length) {
            return Arrays.constantTimeAreEqual(expect, expected);
        }
        if (expect.length == expected.length - 2) {
            int i;
            int sigOffset = expect.length - hash.length - 2;
            int expectedOffset = expected.length - hash.length - 2;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            int nonEqual = 0;
            for (i = 0; i < hash.length; ++i) {
                nonEqual |= expect[sigOffset + i] ^ expected[expectedOffset + i];
            }
            for (i = 0; i < sigOffset; ++i) {
                nonEqual |= expect[i] ^ expected[i];
            }
            return nonEqual == 0;
        }
        Arrays.constantTimeAreEqual(expected, expected);
        return false;
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        if (this.algId == null) {
            try {
                DigestInfo.getInstance(hash);
                return hash;
            }
            catch (IllegalArgumentException e) {
                throw new IOException("malformed DigestInfo for NONEwithRSA hash: " + e.getMessage());
            }
        }
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getEncoded("DER");
    }

    static {
        oidMap.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        oidMap.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        oidMap.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        oidMap.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        oidMap.put("SHA-224", NISTObjectIdentifiers.id_sha224);
        oidMap.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        oidMap.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        oidMap.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        oidMap.put("SHA-512/224", NISTObjectIdentifiers.id_sha512_224);
        oidMap.put("SHA-512/256", NISTObjectIdentifiers.id_sha512_256);
        oidMap.put("SHA3-224", NISTObjectIdentifiers.id_sha3_224);
        oidMap.put("SHA3-256", NISTObjectIdentifiers.id_sha3_256);
        oidMap.put("SHA3-384", NISTObjectIdentifiers.id_sha3_384);
        oidMap.put("SHA3-512", NISTObjectIdentifiers.id_sha3_512);
        oidMap.put("MD2", PKCSObjectIdentifiers.md2);
        oidMap.put("MD4", PKCSObjectIdentifiers.md4);
        oidMap.put("MD5", PKCSObjectIdentifiers.md5);
    }
}

